/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.bean.SerializeControl;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.subclass.SubClassUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyBeanObjectInputStream
extends ObjectInputStream {
    private final SpiEbeanServer ebeanServer;

    public ProxyBeanObjectInputStream(InputStream in, EbeanServer ebeanServer) throws IOException {
        super(in);
        this.ebeanServer = (SpiEbeanServer)ebeanServer;
        SerializeControl.setVanilla(false);
    }

    @Override
    public void close() throws IOException {
        super.close();
        SerializeControl.resetToDefault();
    }

    protected Class<?> resolveGenerated(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        String vanillaClassName = SubClassUtil.getSuperClassName(className);
        Class<?> vanillaClass = Class.forName(vanillaClassName);
        BeanDescriptor<?> d = this.ebeanServer.getBeanDescriptor(vanillaClass);
        if (d == null) {
            String msg = "Could not find BeanDescriptor for " + vanillaClassName;
            throw new IOException(msg);
        }
        return d.getFactoryType();
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        if (SubClassUtil.isSubClass(className)) {
            return this.resolveGenerated(desc);
        }
        return super.resolveClass(desc);
    }
}

