/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompoundScalar;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.reflect.BeanReflectGetter;
import com.avaje.ebeaninternal.server.reflect.BeanReflectSetter;
import com.avaje.ebeaninternal.server.type.CtCompoundProperty;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPropertyCompoundRoot {
    private static Object[] NO_ARGS = new Object[0];
    private final BeanReflectGetter getter;
    private final BeanReflectSetter setter;
    private final Method readMethod;
    private final Method writeMethod;
    private final String name;
    private final LinkedHashMap<String, BeanPropertyCompoundScalar> propMap;
    private final ArrayList<BeanPropertyCompoundScalar> propList;
    private List<CtCompoundProperty> nonScalarProperties;

    public BeanPropertyCompoundRoot(DeployBeanProperty deploy) {
        this.name = deploy.getName();
        this.getter = deploy.getGetter();
        this.setter = deploy.getSetter();
        this.readMethod = deploy.getReadMethod();
        this.writeMethod = deploy.getWriteMethod();
        this.propList = new ArrayList();
        this.propMap = new LinkedHashMap();
    }

    public BeanProperty[] getScalarProperties() {
        return this.propList.toArray(new BeanProperty[this.propList.size()]);
    }

    public void register(BeanPropertyCompoundScalar prop) {
        this.propList.add(prop);
        this.propMap.put(prop.getName(), prop);
    }

    public BeanPropertyCompoundScalar getCompoundScalarProperty(String propName) {
        return this.propMap.get(propName);
    }

    public List<CtCompoundProperty> getNonScalarProperties() {
        return this.nonScalarProperties;
    }

    public void setNonScalarProperties(List<CtCompoundProperty> nonScalarProperties) {
        this.nonScalarProperties = nonScalarProperties;
    }

    public Object getValue(Object bean) {
        try {
            if (bean instanceof EntityBean) {
                return this.getter.get(bean);
            }
            return this.readMethod.invoke(bean, NO_ARGS);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "get " + this.name + " on type[" + beanType + "] threw error.";
            throw new RuntimeException(msg, ex);
        }
    }

    public void setValue(Object bean, Object value) {
        try {
            if (bean instanceof EntityBean) {
                this.setter.set(bean, value);
            } else {
                Object[] args = new Object[]{value};
                this.writeMethod.invoke(bean, args);
            }
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "set " + this.name + " with arg[" + value + "] on type[" + beanType + "] threw error";
            throw new RuntimeException(msg, ex);
        }
    }

    public void setValueIntercept(Object bean, Object value) {
        try {
            if (bean instanceof EntityBean) {
                this.setter.setIntercept(bean, value);
            } else {
                Object[] args = new Object[]{value};
                this.writeMethod.invoke(bean, args);
            }
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "setIntercept " + this.name + " arg[" + value + "] type[" + beanType + "] threw error";
            throw new RuntimeException(msg, ex);
        }
    }
}

