/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.sql;

import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebeaninternal.server.lib.cron.CronManager;
import com.avaje.ebeaninternal.server.lib.sql.DataSourceException;
import com.avaje.ebeaninternal.server.lib.sql.DataSourceNotify;
import com.avaje.ebeaninternal.server.lib.sql.DataSourcePoolListener;
import com.avaje.ebeaninternal.server.lib.sql.PooledConnection;
import com.avaje.ebeaninternal.server.lib.sql.TransactionIsolation;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourcePool
implements DataSource {
    private static final Logger logger = Logger.getLogger(DataSourcePool.class.getName());
    private final String name;
    private final DataSourceNotify notify;
    private final DataSourcePoolListener poolListener;
    private final Properties connectionProps;
    private final String databaseUrl;
    private final String databaseDriver;
    private final String heartbeatsql;
    private final int transactionIsolation;
    private final boolean autoCommit;
    private boolean captureStackTrace;
    private int maxStackTraceSize;
    private boolean dataSourceDownAlertSent;
    private long lastTrimTime;
    private long lastResetTime;
    private boolean dataSourceUp = true;
    private boolean inWarningMode;
    private int warningSize;
    private int pstmtCacheSize;
    private int minConnections;
    private int maxConnections;
    private int waitTimeoutMillis;
    private boolean doingShutdown;
    private int maxInactiveTimeSecs;
    private int uniqueConnectionID;
    private final ArrayList<PooledConnection> freeList = new ArrayList();
    private final ArrayList<PooledConnection> busyList = new ArrayList();
    private long leakTimeMinutes;

    public DataSourcePool(DataSourceNotify notify, String name, DataSourceConfig params) {
        this.notify = notify;
        this.name = name;
        this.poolListener = this.createPoolListener(params.getPoolListener());
        this.autoCommit = false;
        this.transactionIsolation = 2;
        this.maxInactiveTimeSecs = params.getMaxInactiveTimeSecs();
        this.leakTimeMinutes = params.getLeakTimeMinutes();
        this.captureStackTrace = params.isCaptureStackTrace();
        this.maxStackTraceSize = params.getMaxStackTraceSize();
        this.databaseDriver = params.getDriver();
        this.databaseUrl = params.getUrl();
        this.pstmtCacheSize = params.getPstmtCacheSize();
        this.minConnections = params.getMinConnections();
        this.maxConnections = params.getMaxConnections();
        this.waitTimeoutMillis = params.getWaitTimeoutMillis();
        this.heartbeatsql = params.getHeartbeatSql();
        String un = params.getUsername();
        String pw = params.getPassword();
        if (un == null) {
            throw new RuntimeException("DataSource user is null?");
        }
        if (pw == null) {
            throw new RuntimeException("DataSource password is null?");
        }
        this.connectionProps = new Properties();
        this.connectionProps.setProperty("user", un);
        this.connectionProps.setProperty("password", pw);
        try {
            this.initialise();
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex);
        }
    }

    private DataSourcePoolListener createPoolListener(String cn) {
        if (cn == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(cn);
            return (DataSourcePoolListener)cls.newInstance();
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
    }

    private void initialise() throws SQLException {
        try {
            Class.forName(this.databaseDriver);
        }
        catch (Throwable e) {
            throw new PersistenceException("Problem loading Database Driver [" + this.databaseDriver + "]: " + e.getMessage(), e);
        }
        String transIsolation = TransactionIsolation.getLevelDescription(this.transactionIsolation);
        StringBuffer sb = new StringBuffer();
        sb.append("DataSourcePool [").append(this.name);
        sb.append("] autoCommit[").append(this.autoCommit);
        sb.append("] transIsolation[").append(transIsolation);
        sb.append("] min[").append(this.minConnections);
        sb.append("] max[").append(this.maxConnections).append("]");
        logger.info(sb.toString());
        this.ensureMinimumConnections();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public String getName() {
        return this.name;
    }

    public int getMaxStackTraceSize() {
        return this.maxStackTraceSize;
    }

    public boolean isDataSourceUp() {
        return this.dataSourceUp;
    }

    private void notifyDataSourceIsDown(SQLException ex) {
        if (this.isExpectedToBeDownNow()) {
            if (this.dataSourceUp) {
                String msg = "DataSourcePool [" + this.name + "] is down but in downtime!";
                logger.log(Level.WARNING, msg, ex);
            }
        } else if (!this.dataSourceDownAlertSent) {
            String msg = "FATAL: DataSourcePool [" + this.name + "] is down!!!";
            logger.log(Level.SEVERE, msg, ex);
            if (this.notify != null) {
                this.notify.notifyDataSourceDown(this.name);
            }
            this.dataSourceDownAlertSent = true;
        }
        if (this.dataSourceUp) {
            this.reset();
        }
        this.dataSourceUp = false;
    }

    private void notifyDataSourceIsUp() {
        if (this.dataSourceDownAlertSent) {
            String msg = "RESOLVED FATAL: DataSourcePool [" + this.name + "] is back up!";
            logger.log(Level.SEVERE, msg);
            if (this.notify != null) {
                this.notify.notifyDataSourceUp(this.name);
            }
            this.dataSourceDownAlertSent = false;
        } else if (!this.dataSourceUp) {
            logger.log(Level.WARNING, "DataSourcePool [" + this.name + "] is back up!");
        }
        if (!this.dataSourceUp) {
            this.dataSourceUp = true;
            this.reset();
        }
    }

    protected void checkDataSource() {
        try {
            Connection conn = this.createUnpooledConnection();
            this.testConnection(conn);
            conn.close();
            this.notifyDataSourceIsUp();
            if (System.currentTimeMillis() > this.lastTrimTime + (long)(this.maxInactiveTimeSecs * 1000)) {
                this.trimInactiveConnections();
                this.ensureMinimumConnections();
                this.lastTrimTime = System.currentTimeMillis();
            }
        }
        catch (SQLException ex) {
            this.notifyDataSourceIsDown(ex);
        }
    }

    private boolean isExpectedToBeDownNow() {
        return CronManager.isDowntime();
    }

    public Connection createUnpooledConnection() throws SQLException {
        try {
            Connection conn = DriverManager.getConnection(this.databaseUrl, this.connectionProps);
            conn.setAutoCommit(this.autoCommit);
            conn.setTransactionIsolation(this.transactionIsolation);
            return conn;
        }
        catch (SQLException ex) {
            this.notifyDataSourceIsDown(null);
            throw ex;
        }
    }

    public void setMaxSize(int max) {
        this.maxConnections = max;
    }

    public int getMaxSize() {
        return this.maxConnections;
    }

    public void setMinSize(int min) {
        this.minConnections = min;
    }

    public int getMinSize() {
        return this.minConnections;
    }

    public void setMaxInactiveTimeSecs(int maxInactiveTimeSecs) {
        this.maxInactiveTimeSecs = maxInactiveTimeSecs;
    }

    public int getMaxInactiveTimeSecs() {
        return this.maxInactiveTimeSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(Connection conn) throws SQLException {
        if (this.heartbeatsql == null) {
            return;
        }
        Statement stmt = null;
        ResultSet rset = null;
        try {
            stmt = conn.createStatement();
            rset = stmt.executeQuery(this.heartbeatsql);
            conn.commit();
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, null, e);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, null, e);
            }
        }
    }

    protected boolean validateConnection(PooledConnection conn) {
        try {
            if (this.heartbeatsql == null) {
                logger.info("Can not test connection as heartbeatsql is not set");
                return false;
            }
            this.testConnection(conn);
            return true;
        }
        catch (Exception e) {
            String desc = "heartbeatsql test failed on connection[" + conn.getName() + "]";
            logger.warning(desc);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(PooledConnection pooledConnection) {
        if (this.poolListener != null) {
            this.poolListener.onBeforeReturnConnection(pooledConnection);
        }
        if (pooledConnection.getCreationTime() <= this.lastResetTime) {
            pooledConnection.closeConnectionFully(false);
        } else {
            ArrayList<PooledConnection> arrayList = this.freeList;
            synchronized (arrayList) {
                if (!this.busyList.remove(pooledConnection)) {
                    logger.warning("Connection [" + pooledConnection + "] not found in BusyList? ");
                }
                this.freeList.add(pooledConnection);
                this.freeList.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(PooledConnection pooledConnection) {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            this.busyList.remove(pooledConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBusyConnectionInformation() {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            StringBuilder sb = new StringBuilder();
            for (PooledConnection pc : this.busyList) {
                sb.append(pc.getDescription()).append("\r\n");
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBusyConnectionInformation() {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            logger.info("Dumping busy connections: (Use datasource.xxx.capturestacktrace=true  ... to get stackTraces)");
            for (PooledConnection pc : this.busyList) {
                logger.info(pc.getDescription());
                this.logStackElement(pc, "Busy Connection: ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeBusyConnections(long leakTimeMinutes) {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            long olderThanTime = System.currentTimeMillis() - leakTimeMinutes * 60000L;
            ArrayList<PooledConnection> listToClose = new ArrayList<PooledConnection>();
            for (PooledConnection pc : this.busyList) {
                if (pc.isLongRunning() || pc.getLastUsedTime() > olderThanTime) continue;
                listToClose.add(pc);
            }
            for (PooledConnection pc : listToClose) {
                try {
                    String methodLine = pc.getCreatedByMethod();
                    Date luDate = new Date();
                    luDate.setTime(pc.getLastUsedTime());
                    String msg = "DataSourcePool closing leaked connection?  name[" + pc.getName() + "] lastUsed[" + luDate + "] createdBy[" + methodLine + "] lastStmt[" + pc.getLastStatement() + "]";
                    logger.warning(msg);
                    this.logStackElement(pc, "Possible Leaked Connection: ");
                    pc.close();
                }
                catch (SQLException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void logStackElement(PooledConnection pc, String prefix) {
        Object[] stackTrace = pc.getStackTrace();
        if (stackTrace != null) {
            String s = Arrays.toString(stackTrace);
            String msg = prefix + " name[" + pc.getName() + "] stackTrace: " + s;
            logger.warning(msg);
            System.err.println(msg);
        }
    }

    private PooledConnection createConnection() throws SQLException {
        PooledConnection connection = null;
        try {
            ++this.uniqueConnectionID;
            Connection c = this.createUnpooledConnection();
            connection = new PooledConnection(this, this.uniqueConnectionID, c);
            connection.resetForUse();
            if (!this.dataSourceUp) {
                this.notifyDataSourceIsUp();
            }
        }
        catch (SQLException ex) {
            this.notifyDataSourceIsDown(ex);
            throw ex;
        }
        int busy = this.busyList.size();
        int size = busy + this.freeList.size();
        String msg = "DataSourcePool [" + this.name + "] grow pool; " + " busy[" + busy + "] size[" + size + "] max[" + this.maxConnections + "]";
        logger.info(msg);
        this.checkForWarningSize();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            logger.info("Reseting DataSourcePool [" + this.name + "]");
            this.lastResetTime = System.currentTimeMillis();
            this.closeFreeConnections(false);
            this.closeBusyConnections(this.leakTimeMinutes);
            String busyMsg = "Busy Connections:\r\n" + this.getBusyConnectionInformation();
            logger.info(busyMsg);
            this.inWarningMode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFreeConnections(boolean logErrors) {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            while (!this.freeList.isEmpty()) {
                PooledConnection conn = this.freeList.remove(0);
                logger.info("PSTMT Statistics: " + conn.getStatistics());
                conn.closeConnectionFully(logErrors);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getPooledConnection();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        PooledConnection c = this._getPooledConnection();
        if (this.captureStackTrace) {
            c.setStackTrace(Thread.currentThread().getStackTrace());
        }
        if (this.poolListener != null) {
            this.poolListener.onAfterBorrowConnection(c);
        }
        return c;
    }

    private PooledConnection _getPooledConnection() throws SQLException {
        if (this.doingShutdown) {
            throw new SQLException("Trying to access the Connection Pool when it is shutting down");
        }
        PooledConnection connection = null;
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            int freeSize = this.freeList.size();
            if (freeSize > 0) {
                connection = this.freeList.remove(freeSize - 1);
                connection.resetForUse();
                this.busyList.add(connection);
                return connection;
            }
            int busySize = this.busyList.size();
            if (busySize + freeSize < this.maxConnections) {
                connection = this.createConnection();
                this.busyList.add(connection);
                return connection;
            }
            this.reset();
            try {
                this.freeList.wait(this.waitTimeoutMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this.freeList.isEmpty()) {
                connection = this.freeList.remove(0);
                connection.resetForUse();
                this.busyList.add(connection);
                return connection;
            }
            String s = "Unsuccessfully waited for a connection to be returned. No connections are free. You need to Increase the max connections or look for a connection pool leak.";
            throw new SQLException(s);
        }
    }

    public void testAlert() {
        String subject = "Test DataSourcePool [" + this.name + "]";
        String msg = "Just testing if alert message is sent successfully.";
        if (this.notify != null) {
            this.notify.notifyWarning(subject, msg);
        }
    }

    private void checkForWarningSize() {
        int availableGrowth = this.maxConnections - this.getSize();
        if (availableGrowth < this.warningSize) {
            this.closeBusyConnections(this.leakTimeMinutes);
            if (!this.inWarningMode) {
                this.inWarningMode = true;
                String subject = "DataSourcePool [" + this.name + "] warning";
                String msg = "DataSourcePool [" + this.name + "] is [" + availableGrowth + "] connections from its maximum size.";
                logger.warning(msg);
                if (this.notify != null) {
                    this.notify.notifyWarning(subject, msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            String m = "DataSourcePool [" + this.name + "] shutdown";
            logger.info(m);
            this.doingShutdown = true;
            this.closeFreeConnections(true);
            if (this.getSize() > 0) {
                String msg = "A potential connection leak was detected.  Total connections: " + this.getSize();
                logger.warning(msg);
                this.dumpBusyConnectionInformation();
                this.closeBusyConnections(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimInactiveConnections() {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            int maxTrim = this.freeList.size() - this.minConnections;
            if (maxTrim <= 0) {
                return;
            }
            int trimedCount = 0;
            long usedSince = System.currentTimeMillis() - (long)(this.maxInactiveTimeSecs * 1000);
            Iterator<PooledConnection> it = this.freeList.iterator();
            while (it.hasNext()) {
                PooledConnection conn = it.next();
                if (conn.getLastUsedTime() >= usedSince) continue;
                it.remove();
                conn.closeConnectionFully(true);
                if (++trimedCount < maxTrim) continue;
                break;
            }
            if (trimedCount > 0) {
                String msg = "DataSourcePool [" + this.name + "] trimmed [" + trimedCount + "] inactive connections size[" + this.getSize() + "]";
                logger.info(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMinimumConnections() {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            if (this.getSize() < this.minConnections) {
                return;
            }
            int numToAdd = this.minConnections - this.getSize();
            if (numToAdd > 0) {
                try {
                    for (int i = 0; i < numToAdd; ++i) {
                        PooledConnection conn = this.createConnection();
                        this.freeList.add(conn);
                    }
                    this.freeList.notify();
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, null, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBusyCount() {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            return this.busyList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        ArrayList<PooledConnection> arrayList = this.freeList;
        synchronized (arrayList) {
            return this.freeList.size() + this.busyList.size();
        }
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public boolean isCaptureStackTrace() {
        return this.captureStackTrace;
    }

    public void setCaptureStackTrace(boolean captureStackTrace) {
        this.captureStackTrace = captureStackTrace;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public void setLeakTimeMinutes(long leakTimeMinutes) {
        this.leakTimeMinutes = leakTimeMinutes;
    }

    public long getLeakTimeMinutes() {
        return this.leakTimeMinutes;
    }

    public int getPstmtCacheSize() {
        return this.pstmtCacheSize;
    }

    public void setPstmtCacheSize(int pstmtCacheSize) {
        this.pstmtCacheSize = pstmtCacheSize;
    }
}

