/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

import com.avaje.ebeaninternal.net.AuthenticateResponse;
import com.avaje.ebeaninternal.net.Command;
import com.avaje.ebeaninternal.net.CommandContext;
import com.avaje.ebeaninternal.net.CommandList;
import com.avaje.ebeaninternal.net.Constants;
import com.avaje.ebeaninternal.server.net.Authenticate;
import com.avaje.ebeaninternal.server.net.CommandContextManager;
import com.avaje.ebeaninternal.server.net.CommandSecurity;
import com.avaje.ebeaninternal.server.net.ConnectionProcessor;
import com.avaje.ebeaninternal.server.net.Headers;
import com.avaje.ebeaninternal.server.net.IoConnection;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandProcessor
implements ConnectionProcessor,
Constants {
    private static final Logger logger = Logger.getLogger(CommandProcessor.class.getName());
    CommandContextManager contextManager;
    Authenticate authenticate;
    CommandSecurity commandSecurity;
    boolean useSessionId = false;
    long sessCounter = 0L;
    boolean embedMethodInfo = false;

    public void setAuthenticate(Authenticate authenticate) {
        this.authenticate = authenticate;
    }

    public void setContextManager(CommandContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public void setCommandSecurity(CommandSecurity commandSecurity) {
        this.commandSecurity = commandSecurity;
    }

    public void setUseSessionId(boolean useSessionId) {
        this.useSessionId = useSessionId;
    }

    public AuthenticateResponse authenticate(String un, String pwd, Object obj) {
        return this.authenticate.authenticate(un, pwd, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextSessionId() {
        CommandProcessor commandProcessor = this;
        synchronized (commandProcessor) {
            return ++this.sessCounter + "";
        }
    }

    protected void execute(CommandContext context, Command command) {
        if (this.commandSecurity != null && !this.commandSecurity.allow(context, command)) {
            String m = "Disallowed Command " + command + " " + context;
            logger.log(Level.SEVERE, m);
            return;
        }
        command.execute(context);
    }

    public void process(IoConnection request) {
        Headers h = request.getHeaders();
        try {
            String sessId;
            Serializable responseObject = null;
            CommandContext context = this.contextManager.getContext(h);
            context.setProcessor(this);
            Object payload = request.readObject();
            if (payload instanceof Command) {
                Command command = (Command)payload;
                this.execute(context, command);
                responseObject = command;
            } else {
                CommandList commandList = (CommandList)payload;
                List<Command> cmdList = commandList.list();
                for (int i = 0; i < cmdList.size(); ++i) {
                    Command cmd = cmdList.get(i);
                    this.execute(context, cmd);
                }
                responseObject = commandList;
            }
            Headers response = new Headers();
            response.setSuccess();
            if (this.useSessionId && (sessId = h.get("ebean.session.id")) == null) {
                sessId = this.nextSessionId();
                response.set("ebean.session.id", sessId);
            }
            request.writeObject(response);
            request.writeObject(responseObject);
            request.flush();
        }
        catch (Exception ex) {
            String msg = "Error handling request:" + h;
            logger.log(Level.SEVERE, msg, ex);
            try {
                Headers res = new Headers();
                res.setThrowable(ex);
                request.writeObject(res).flush();
            }
            catch (IOException e) {
                String m = "Error sending error response back to client:" + e.getMessage();
                logger.log(Level.SEVERE, m, e);
            }
        }
    }
}

