/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

import com.avaje.ebeaninternal.server.net.HttpCookieDateParser;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;

public class HttpCookie {
    private Date expirationDate;
    private String nameAndValue;
    private String path;
    private String domain;
    private boolean isSecure = false;
    HttpCookieDateParser dateParser;

    public HttpCookie(String rawCookieString, HttpCookieDateParser dateParser) {
        this.dateParser = dateParser;
        this.parseCookieString(rawCookieString);
    }

    public HttpCookie(Date expirationDate, String nameAndValue, String path, String domain, boolean isSecure) {
        this.expirationDate = new Date(expirationDate.getTime());
        this.nameAndValue = nameAndValue;
        this.path = path;
        this.domain = domain;
        this.isSecure = isSecure;
    }

    public HttpCookie(URL url, String rawCookieString) {
        this.parseCookieString(rawCookieString);
        this.applyDefaults(url);
    }

    private void applyDefaults(URL url) {
        if (this.domain == null) {
            this.domain = url.getHost();
        }
        if (this.path == null) {
            this.path = url.getFile();
            int i = this.path.lastIndexOf("/");
            if (i > -1) {
                this.path = this.path.substring(0, i);
            }
        }
    }

    private void parseCookieString(String s) {
        StringTokenizer stringtokenizer = new StringTokenizer(s, ";");
        stringtokenizer.hasMoreTokens();
        this.nameAndValue = stringtokenizer.nextToken().trim();
        while (stringtokenizer.hasMoreTokens()) {
            String s1 = stringtokenizer.nextToken().trim();
            if (s1.equalsIgnoreCase("secure")) {
                this.isSecure = true;
                continue;
            }
            int i = s1.indexOf("=");
            if (i < 0) continue;
            String name = s1.substring(0, i);
            String value = s1.substring(i + 1);
            if (name.equalsIgnoreCase("path")) {
                this.path = value;
                continue;
            }
            if (name.equalsIgnoreCase("domain")) {
                if (value.indexOf(".") == 0) {
                    this.domain = value.substring(1);
                    continue;
                }
                this.domain = value;
                continue;
            }
            if (!name.equalsIgnoreCase("expires")) continue;
            this.expirationDate = this.parseExpireDate(value);
        }
    }

    public String getNameValue() {
        return this.nameAndValue;
    }

    public String getName() {
        int i = this.nameAndValue.indexOf("=");
        return this.nameAndValue.substring(0, i);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public boolean hasExpired() {
        return this.expirationDate != null && this.expirationDate.getTime() <= System.currentTimeMillis();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private Date parseExpireDate(String expireDate) {
        return this.dateParser.parse(expireDate);
    }

    public String toString() {
        String s = this.nameAndValue;
        if (this.expirationDate != null) {
            s = s + "; expires=" + this.expirationDate;
        }
        if (this.path != null) {
            s = s + "; path=" + this.path;
        }
        if (this.domain != null) {
            s = s + "; domain=" + this.domain;
        }
        if (this.isSecure) {
            s = s + "; secure";
        }
        return s;
    }
}

