/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

import com.avaje.ebeaninternal.server.net.HttpCookie;
import com.avaje.ebeaninternal.server.net.HttpCookieDateParser;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpCookieList {
    private Hashtable<String, HttpCookie> cookieMap = new Hashtable();
    HttpCookieDateParser dateParser = new HttpCookieDateParser();

    public void getCookiesFromConnection(URLConnection urlconnection) {
        String headerKey;
        int i = 1;
        while ((headerKey = urlconnection.getHeaderFieldKey(i)) != null) {
            if (headerKey.equalsIgnoreCase("set-cookie")) {
                String rawCookieHeader = urlconnection.getHeaderField(i);
                HttpCookie cookie = new HttpCookie(rawCookieHeader, this.dateParser);
                this.cookieMap.put(cookie.getName(), cookie);
            }
            ++i;
        }
    }

    public void setCookiesToConnection(URLConnection urlconnection) {
        if (this.cookieMap.size() < 1) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Enumeration<HttpCookie> e = this.cookieMap.elements();
        while (e.hasMoreElements()) {
            HttpCookie cookie = e.nextElement();
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(cookie.getNameValue());
        }
        urlconnection.setRequestProperty("Cookie", sb.toString());
    }
}

