/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

import com.avaje.ebeaninternal.server.net.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class IoConnection {
    ObjectOutputStream oos;
    ObjectInputStream ois;
    Headers headers;
    InputStream is;
    OutputStream os;

    public IoConnection(InputStream is, OutputStream os) {
        this.is = is;
        this.os = os;
    }

    public void disconnect() throws IOException {
        this.os.flush();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.getObjectInputStream().readObject();
    }

    public ObjectOutputStream writeObject(Object object) throws IOException {
        ObjectOutputStream oos = this.getObjectOutputStream();
        oos.writeObject(object);
        return oos;
    }

    public ObjectOutputStream getObjectOutputStream() throws IOException {
        if (this.oos == null) {
            this.oos = new ObjectOutputStream(this.os);
        }
        return this.oos;
    }

    public ObjectInputStream getObjectInputStream() throws IOException {
        if (this.ois == null) {
            this.ois = new ObjectInputStream(this.is);
        }
        return this.ois;
    }

    public void setObjectInputStream(ObjectInputStream ois) {
        this.ois = ois;
    }

    public void setObjectOutputStream(ObjectOutputStream oos) {
        this.oos = oos;
    }

    public InputStream getInputStream() throws IOException {
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }
}

