/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebeaninternal.server.lib.thread.ThreadPool;
import com.avaje.ebeaninternal.server.lib.thread.ThreadPoolManager;
import com.avaje.ebeaninternal.server.net.ConnectionProcessor;
import com.avaje.ebeaninternal.server.net.SocketDispatcher;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketListener
implements Runnable {
    private static final Logger logger = Logger.getLogger(SocketListener.class.getName());
    int port = -1;
    int listenTimeout = 60000;
    ServerSocket serverListenSocket;
    boolean doingShutdown = false;
    Thread listenerThread;
    boolean isActive = false;
    ThreadPool threadPool;
    HashMap<String, ConnectionProcessor> processorMap = new HashMap();

    public SocketListener(String threadPoolName, int port) {
        this.threadPool = ThreadPoolManager.getThreadPool(threadPoolName);
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void startListening() throws IOException {
        this.serverListenSocket = new ServerSocket(this.port);
        this.serverListenSocket.setSoTimeout(this.listenTimeout);
        this.listenerThread = new Thread((Runnable)this, "avaje.lib.SocketListener");
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionProcessor getRequestProcessor(String serviceKey) throws IOException {
        ConnectionProcessor handler = this.processorMap.get(serviceKey);
        if (handler == null) {
            HashMap<String, ConnectionProcessor> hashMap = this.processorMap;
            synchronized (hashMap) {
                handler = this.processorMap.get(serviceKey);
                if (handler == null) {
                    handler = this.createRequestHandler(serviceKey);
                    this.processorMap.put(serviceKey, handler);
                }
            }
        }
        return handler;
    }

    protected ConnectionProcessor createRequestHandler(String serviceKey) throws IOException {
        serviceKey = serviceKey.toLowerCase();
        String handlerName = GlobalProperties.get("connectionprocessor." + serviceKey, null);
        if (handlerName == null) {
            String msg = "No ConnectionProcessor has been defined for [" + serviceKey + "]";
            throw new IOException(msg);
        }
        try {
            Class<?> hClass = Class.forName(handlerName);
            ConnectionProcessor h = (ConnectionProcessor)hClass.newInstance();
            return h;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            throw new IOException("Exception " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRequestHandler(String serviceKey, ConnectionProcessor handler) {
        HashMap<String, ConnectionProcessor> hashMap = this.processorMap;
        synchronized (hashMap) {
            this.processorMap.put(serviceKey, handler);
        }
    }

    public void registerRequestHandler(String serviceKey, String requestHandlerClassName) {
        try {
            Class<?> c = Class.forName(requestHandlerClassName);
            ConnectionProcessor requestHandler = (ConnectionProcessor)c.newInstance();
            this.registerRequestHandler(serviceKey, requestHandler);
        }
        catch (Exception e) {
            String msg = "Error creating RequestHandler [" + serviceKey + "][" + requestHandlerClassName + "]";
            logger.log(Level.SEVERE, msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.doingShutdown = true;
        try {
            if (this.isActive) {
                Thread thread = this.listenerThread;
                synchronized (thread) {
                    try {
                        this.listenerThread.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.listenerThread.interrupt();
            this.serverListenSocket.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, null, e);
        }
    }

    protected Runnable createRunnable(SocketListener listener, Socket clientSocket) {
        return new SocketDispatcher(this, clientSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.doingShutdown) {
            try {
                Thread thread = this.listenerThread;
                synchronized (thread) {
                    Socket clientSocket = this.serverListenSocket.accept();
                    this.isActive = true;
                    Runnable request = this.createRunnable(this, clientSocket);
                    this.threadPool.assign(request, true);
                    this.isActive = false;
                }
            }
            catch (SocketException e) {
                if (this.doingShutdown) {
                    String msg = "com.avaje.lib.SocketListener> doingShutdown and accept threw:" + e.getMessage();
                    logger.info(msg);
                    continue;
                }
                logger.log(Level.SEVERE, null, e);
            }
            catch (InterruptedIOException e) {
                logger.fine("Possibly expected due to accept timeout?" + e.getMessage());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, null, e);
            }
        }
    }
}

