/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Page;
import com.avaje.ebeaninternal.server.query.LimitOffsetPagingQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitOffsetList<T>
implements List<T> {
    private final LimitOffsetPagingQuery<T> owner;
    private List<T> localCopy;

    public LimitOffsetList(LimitOffsetPagingQuery<T> owner) {
        this.owner = owner;
    }

    private void ensureLocalCopy() {
        block1: {
            Page<T> page;
            if (this.localCopy != null) break block1;
            this.localCopy = new ArrayList<T>();
            int pgIndex = 0;
            do {
                page = this.owner.getPage(pgIndex++);
                List<T> list = page.getList();
                this.localCopy.addAll(list);
            } while (page.hasNext());
        }
    }

    private boolean hasNext(int position) {
        return this.owner.hasNext(position);
    }

    @Override
    public void clear() {
        this.localCopy = new ArrayList<T>();
    }

    @Override
    public T get(int index) {
        if (this.localCopy != null) {
            return this.localCopy.get(index);
        }
        return this.owner.get(index);
    }

    @Override
    public boolean isEmpty() {
        if (this.localCopy != null) {
            return this.localCopy.isEmpty();
        }
        return this.owner.getTotalRowCount() == 0;
    }

    @Override
    public int size() {
        if (this.localCopy != null) {
            return this.localCopy.size();
        }
        return this.owner.getTotalRowCount();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.localCopy != null) {
            return this.localCopy.iterator();
        }
        return new ListItr(this, 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        if (this.localCopy != null) {
            return this.localCopy.listIterator();
        }
        return new ListItr(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (this.localCopy != null) {
            return this.localCopy.listIterator(index);
        }
        return new ListItr(this, index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (this.localCopy != null) {
            return this.localCopy.subList(fromIndex, toIndex);
        }
        throw new RuntimeException("Not implemented at this point");
    }

    @Override
    public int lastIndexOf(Object o) {
        this.ensureLocalCopy();
        return this.localCopy.lastIndexOf(o);
    }

    @Override
    public void add(int index, T element) {
        this.ensureLocalCopy();
        this.localCopy.add(index, element);
    }

    @Override
    public boolean add(T o) {
        this.ensureLocalCopy();
        return this.localCopy.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.ensureLocalCopy();
        return this.localCopy.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.ensureLocalCopy();
        return this.localCopy.addAll(index, c);
    }

    @Override
    public boolean contains(Object o) {
        this.ensureLocalCopy();
        return this.localCopy.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.ensureLocalCopy();
        return this.localCopy.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        this.ensureLocalCopy();
        return this.localCopy.indexOf(o);
    }

    @Override
    public T remove(int index) {
        this.ensureLocalCopy();
        return this.localCopy.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.ensureLocalCopy();
        return this.localCopy.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.ensureLocalCopy();
        return this.localCopy.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.ensureLocalCopy();
        return this.localCopy.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        this.ensureLocalCopy();
        return this.localCopy.set(index, element);
    }

    @Override
    public Object[] toArray() {
        this.ensureLocalCopy();
        return this.localCopy.toArray();
    }

    @Override
    public <K> K[] toArray(K[] a) {
        this.ensureLocalCopy();
        return this.localCopy.toArray(a);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    implements ListIterator<T> {
        private LimitOffsetList<T> owner;
        private int position;

        ListItr(LimitOffsetList<T> owner, int position) {
            this.owner = owner;
            this.position = position;
        }

        @Override
        public void add(T o) {
            this.owner.add(this.position++, o);
        }

        @Override
        public boolean hasNext() {
            return this.owner.hasNext(this.position);
        }

        @Override
        public boolean hasPrevious() {
            return this.position > 0;
        }

        @Override
        public T next() {
            return this.owner.get(this.position++);
        }

        @Override
        public int nextIndex() {
            return this.position;
        }

        @Override
        public T previous() {
            return LimitOffsetList.this.get(--this.position);
        }

        @Override
        public int previousIndex() {
            return this.position - 1;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not supported yet");
        }

        @Override
        public void set(T o) {
            throw new RuntimeException("Not supported yet");
        }
    }
}

