/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebean.JoinConfig;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmQueryDetail
implements Serializable {
    private static final long serialVersionUID = -2510486880141461806L;
    private OrmQueryProperties baseProps = new OrmQueryProperties();
    private LinkedHashMap<String, OrmQueryProperties> joins = new LinkedHashMap(8);
    private HashSet<String> includes = new HashSet(8);

    public OrmQueryDetail copy() {
        OrmQueryDetail copy = new OrmQueryDetail();
        copy.baseProps = this.baseProps.copy();
        for (Map.Entry<String, OrmQueryProperties> entry : this.joins.entrySet()) {
            copy.joins.put(entry.getKey(), entry.getValue().copy());
        }
        copy.includes = new HashSet<String>(this.includes);
        return copy;
    }

    public int queryPlanHash(BeanQueryRequest<?> request) {
        int hc;
        int n = hc = this.baseProps == null ? 1 : this.baseProps.queryPlanHash(request);
        if (this.joins != null) {
            for (OrmQueryProperties p : this.joins.values()) {
                hc = hc * 31 + p.queryPlanHash(request);
            }
        }
        return hc;
    }

    public boolean isAutoFetchEqual(OrmQueryDetail otherDetail) {
        return this.autofetchPlanHash() == otherDetail.autofetchPlanHash();
    }

    private int autofetchPlanHash() {
        int hc;
        int n = hc = this.baseProps == null ? 1 : this.baseProps.autofetchPlanHash();
        if (this.joins != null) {
            for (OrmQueryProperties p : this.joins.values()) {
                hc = hc * 31 + p.autofetchPlanHash();
            }
        }
        return hc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.baseProps != null) {
            sb.append("select ").append(this.baseProps);
        }
        if (this.joins != null) {
            for (OrmQueryProperties join : this.joins.values()) {
                sb.append(" join ").append(join);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        throw new RuntimeException("should not use");
    }

    public void select(String columns) {
        this.baseProps = new OrmQueryProperties(null, columns, null);
    }

    public boolean containsProperty(String property) {
        if (this.baseProps == null) {
            return true;
        }
        return this.baseProps.isIncluded(property);
    }

    public void setBase(OrmQueryProperties baseProps) {
        this.baseProps = baseProps;
    }

    public List<OrmQueryProperties> removeSecondaryQueries() {
        return this.removeSecondaryQueries(false);
    }

    public List<OrmQueryProperties> removeSecondaryLazyQueries() {
        return this.removeSecondaryQueries(true);
    }

    private List<OrmQueryProperties> removeSecondaryQueries(boolean lazyQuery) {
        String path;
        int i;
        ArrayList<String> matchingPaths = new ArrayList<String>(2);
        for (OrmQueryProperties chunk : this.joins.values()) {
            boolean match = lazyQuery ? chunk.isLazyJoin() : chunk.isQueryJoin();
            if (!match) continue;
            matchingPaths.add(chunk.getPath());
        }
        if (matchingPaths.size() == 0) {
            return null;
        }
        Collections.sort(matchingPaths);
        ArrayList<OrmQueryProperties> props = new ArrayList<OrmQueryProperties>(2);
        for (i = 0; i < matchingPaths.size(); ++i) {
            path = (String)matchingPaths.get(i);
            this.includes.remove(path);
            OrmQueryProperties secQuery = (OrmQueryProperties)this.joins.remove(path);
            if (secQuery == null) continue;
            props.add(secQuery);
            Iterator<OrmQueryProperties> pass2It = this.joins.values().iterator();
            while (pass2It.hasNext()) {
                OrmQueryProperties pass2Prop = pass2It.next();
                if (!secQuery.isChild(pass2Prop)) continue;
                pass2It.remove();
                this.includes.remove(pass2Prop.getPath());
                secQuery.add(pass2Prop);
            }
        }
        for (i = 0; i < props.size(); ++i) {
            path = props.get(i).getPath();
            String[] split = SplitName.split(path);
            OrmQueryProperties chunk = this.getChunk(split[0], true);
            chunk.addSecondaryQueryJoin(split[1]);
        }
        return props;
    }

    public boolean tuneFetchProperties(OrmQueryDetail tunedDetail) {
        boolean tuned = false;
        OrmQueryProperties tunedRoot = tunedDetail.getChunk(null, false);
        if (tunedRoot != null && tunedRoot.hasProperties()) {
            tuned = true;
            this.baseProps.setTunedProperties(tunedRoot);
            for (OrmQueryProperties tunedChunk : tunedDetail.joins.values()) {
                OrmQueryProperties chunk = this.getChunk(tunedChunk.getPath(), false);
                if (chunk != null) {
                    chunk.setTunedProperties(tunedChunk);
                    continue;
                }
                this.addJoin(tunedChunk.copy());
            }
        }
        return tuned;
    }

    public void addJoin(OrmQueryProperties chunk) {
        String property = chunk.getPath();
        this.joins.put(property, chunk);
        this.includes.add(property);
    }

    public void clear() {
        this.includes.clear();
        this.joins.clear();
    }

    public OrmQueryProperties addJoin(String property, String partialProps, JoinConfig joinConfig) {
        OrmQueryProperties chunk = new OrmQueryProperties(property, partialProps, joinConfig);
        this.addJoin(chunk);
        return chunk;
    }

    public void convertManyFetchJoinsToQueryJoins(BeanDescriptor<?> beanDescriptor, String lazyLoadManyPath, boolean allowOne, int queryBatch, int lazyBatch) {
        ArrayList<OrmQueryProperties> manyChunks = new ArrayList<OrmQueryProperties>(3);
        String manyFetchProperty = null;
        boolean fetchJoinFirstMany = allowOne;
        for (String joinProp : this.joins.keySet()) {
            OrmQueryProperties chunk;
            ElPropertyDeploy elProp = beanDescriptor.getElPropertyDeploy(joinProp);
            if (!elProp.containsManySince(manyFetchProperty) || !(chunk = this.joins.get(joinProp)).isFetchJoin() || this.isLazyLoadManyRoot(lazyLoadManyPath, chunk) || this.hasParentSecJoin(lazyLoadManyPath, chunk)) continue;
            if (fetchJoinFirstMany) {
                fetchJoinFirstMany = false;
                manyFetchProperty = joinProp;
                continue;
            }
            manyChunks.add(chunk);
        }
        for (int i = 0; i < manyChunks.size(); ++i) {
            ((OrmQueryProperties)manyChunks.get(i)).setQueryJoinBatch(queryBatch).setLazyJoinBatch(lazyBatch);
        }
    }

    private boolean isLazyLoadManyRoot(String lazyLoadManyPath, OrmQueryProperties chunk) {
        return lazyLoadManyPath != null && lazyLoadManyPath.equals(chunk.getPath());
    }

    private boolean hasParentSecJoin(String lazyLoadManyPath, OrmQueryProperties chunk) {
        OrmQueryProperties parent = this.getParent(chunk);
        if (parent == null) {
            return false;
        }
        if (lazyLoadManyPath != null && lazyLoadManyPath.equals(parent.getPath())) {
            return false;
        }
        if (!parent.isFetchJoin()) {
            return true;
        }
        return this.hasParentSecJoin(lazyLoadManyPath, parent);
    }

    private OrmQueryProperties getParent(OrmQueryProperties chunk) {
        String parentPath = chunk.getParentPath();
        return parentPath == null ? null : this.joins.get(parentPath);
    }

    public void setDefaultSelectClause(BeanDescriptor<?> desc) {
        if (desc.hasDefaultSelectClause() && !this.hasSelectClause()) {
            if (this.baseProps == null) {
                this.baseProps = new OrmQueryProperties();
            }
            this.baseProps.setProperties(desc.getDefaultSelectClause(), desc.getDefaultSelectClauseSet());
        }
        for (OrmQueryProperties joinProps : this.joins.values()) {
            BeanDescriptor<?> assocDesc;
            if (joinProps.hasSelectClause() || !(assocDesc = desc.getBeanDescriptor(joinProps.getPath())).hasDefaultSelectClause()) continue;
            joinProps.setProperties(assocDesc.getDefaultSelectClause(), assocDesc.getDefaultSelectClauseSet());
        }
    }

    public boolean hasSelectClause() {
        return this.baseProps != null && this.baseProps.hasSelectClause();
    }

    public boolean isEmpty() {
        return this.joins.isEmpty() && (this.baseProps == null || !this.baseProps.hasProperties());
    }

    public boolean isJoinsEmpty() {
        return this.joins.isEmpty();
    }

    public void includeBeanJoin(String parent, String propertyName) {
        OrmQueryProperties parentChunk = this.getChunk(parent, true);
        parentChunk.includeBeanJoin(propertyName);
    }

    public OrmQueryProperties getChunk(String propertyName, boolean create) {
        if (propertyName == null) {
            return this.baseProps;
        }
        OrmQueryProperties props = this.joins.get(propertyName);
        if (create && props == null) {
            return this.addJoin(propertyName, null, null);
        }
        return props;
    }

    public boolean includes(String propertyName) {
        OrmQueryProperties chunk = this.joins.get(propertyName);
        return chunk != null && chunk.isFetchInclude();
    }

    public HashSet<String> getIncludes() {
        return this.includes;
    }
}

