/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeDouble
extends ScalarTypeBase<Double> {
    public ScalarTypeDouble() {
        super(Double.class, true, 8);
    }

    @Override
    public void bind(DataBind b, Double value) throws SQLException {
        if (value == null) {
            b.setNull(8);
        } else {
            b.setDouble(value);
        }
    }

    @Override
    public Double read(DataReader dataReader) throws SQLException {
        return dataReader.getDouble();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toDouble(value);
    }

    @Override
    public Double toBeanType(Object value) {
        return BasicTypeConverter.toDouble(value);
    }

    @Override
    public String formatValue(Double t) {
        return t.toString();
    }

    @Override
    public Double parse(String value) {
        return Double.valueOf(value);
    }

    @Override
    public Double parseDateTime(long systemTimeMillis) {
        return systemTimeMillis;
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }
}

