/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeJodaLocalDateTime
extends ScalarTypeBase<LocalDateTime> {
    public ScalarTypeJodaLocalDateTime() {
        super(LocalDateTime.class, false, 93);
    }

    @Override
    public void bind(DataBind b, LocalDateTime value) throws SQLException {
        if (value == null) {
            b.setNull(93);
        } else {
            Timestamp ts = new Timestamp(value.toDateTime().getMillis());
            b.setTimestamp(ts);
        }
    }

    @Override
    public LocalDateTime read(DataReader dataReader) throws SQLException {
        Timestamp ts = dataReader.getTimestamp();
        if (ts == null) {
            return null;
        }
        return new LocalDateTime(ts.getTime());
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof LocalDateTime) {
            return new Timestamp(((LocalDateTime)value).toDateTime().getMillis());
        }
        return BasicTypeConverter.toTimestamp(value);
    }

    @Override
    public LocalDateTime toBeanType(Object value) {
        if (value instanceof Date) {
            return new LocalDateTime(((Date)value).getTime());
        }
        return (LocalDateTime)value;
    }

    @Override
    public String formatValue(LocalDateTime t) {
        Timestamp ts = new Timestamp(t.toDateTime().getMillis());
        return ts.toString();
    }

    @Override
    public LocalDateTime parse(String value) {
        Timestamp ts = Timestamp.valueOf(value);
        return new LocalDateTime(ts.getTime());
    }

    @Override
    public LocalDateTime parseDateTime(long systemTimeMillis) {
        return new LocalDateTime(systemTimeMillis);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }
}

