/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeLdapBoolean
extends ScalarTypeBase<Boolean> {
    private final String trueValue = "TRUE";
    private final String falseValue = "FALSE";

    public ScalarTypeLdapBoolean() {
        super(Boolean.class, false, 12);
    }

    @Override
    public int getLength() {
        return 5;
    }

    @Override
    public void bind(DataBind b, Boolean value) throws SQLException {
        if (value == null) {
            b.setNull(12);
        } else {
            b.setString(this.toString(value));
        }
    }

    @Override
    public Boolean read(DataReader dataReader) throws SQLException {
        String string = dataReader.getString();
        if (string == null) {
            return null;
        }
        if (string.equals("TRUE")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object toJdbcType(Object value) {
        return this.toString(value);
    }

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        Boolean b = (Boolean)value;
        if (b.booleanValue()) {
            return "TRUE";
        }
        return "FALSE";
    }

    @Override
    public Boolean toBeanType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if ("TRUE".equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String formatValue(Boolean t) {
        return t.toString();
    }

    @Override
    public Boolean parse(String value) {
        return Boolean.valueOf(value);
    }

    @Override
    public Boolean parseDateTime(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }
}

