/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeUUID
extends ScalarTypeBase<UUID> {
    public ScalarTypeUUID() {
        super(UUID.class, false, 12);
    }

    @Override
    public int getLength() {
        return 40;
    }

    @Override
    public void bind(DataBind b, UUID value) throws SQLException {
        if (value == null) {
            b.setNull(12);
        } else {
            b.setString(value.toString());
        }
    }

    @Override
    public UUID read(DataReader dataReader) throws SQLException {
        String str = dataReader.getString();
        if (str == null) {
            return null;
        }
        return UUID.fromString(str);
    }

    @Override
    public UUID toBeanType(Object value) {
        return BasicTypeConverter.toUUID(value);
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.convert(value, this.jdbcType);
    }

    @Override
    public String formatValue(UUID v) {
        return v.toString();
    }

    @Override
    public UUID parse(String value) {
        return UUID.fromString(value);
    }

    @Override
    public UUID parseDateTime(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }
}

