/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class ScalarTypeUtilDate {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateType
    extends ScalarTypeBase<Date> {
        public DateType() {
            super(Date.class, false, 91);
        }

        @Override
        public Date read(DataReader dataReader) throws SQLException {
            java.sql.Date d = dataReader.getDate();
            if (d != null) {
                return new Date(d.getTime());
            }
            return null;
        }

        @Override
        public void bind(DataBind b, Date value) throws SQLException {
            if (value == null) {
                b.setNull(93);
            } else {
                java.sql.Date d = new java.sql.Date(value.getTime());
                b.setDate(d);
            }
        }

        @Override
        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toDate(value);
        }

        @Override
        public Date toBeanType(Object value) {
            return BasicTypeConverter.toUtilDate(value);
        }

        @Override
        public String formatValue(Date v) {
            java.sql.Date sqlDate = new java.sql.Date(v.getTime());
            return sqlDate.toString();
        }

        @Override
        public Date parse(String value) {
            java.sql.Date ts = java.sql.Date.valueOf(value);
            return new Date(ts.getTime());
        }

        @Override
        public Date parseDateTime(long systemTimeMillis) {
            return new Date(systemTimeMillis);
        }

        @Override
        public boolean isDateTimeCapable() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimestampType
    extends ScalarTypeBase<Date> {
        public TimestampType() {
            super(Date.class, false, 93);
        }

        @Override
        public Date read(DataReader dataReader) throws SQLException {
            Timestamp timestamp = dataReader.getTimestamp();
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        @Override
        public void bind(DataBind b, Date value) throws SQLException {
            if (value == null) {
                b.setNull(93);
            } else {
                Timestamp timestamp = new Timestamp(value.getTime());
                b.setTimestamp(timestamp);
            }
        }

        @Override
        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toTimestamp(value);
        }

        @Override
        public Date toBeanType(Object value) {
            return BasicTypeConverter.toUtilDate(value);
        }

        @Override
        public String formatValue(Date v) {
            Timestamp ts = new Timestamp(v.getTime());
            return ts.toString();
        }

        @Override
        public Date parse(String value) {
            Timestamp ts = Timestamp.valueOf(value);
            return new Date(ts.getTime());
        }

        @Override
        public Date parseDateTime(long systemTimeMillis) {
            return new Date(systemTimeMillis);
        }

        @Override
        public boolean isDateTimeCapable() {
            return true;
        }
    }
}

