/*
 * Decompiled with CFR 0.152.
 */
package play.modules.ebean;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.event.BeanPersistController;
import javax.sql.DataSource;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.db.DB;
import play.db.jpa.JPAPlugin;
import play.modules.ebean.EbeanContext;
import play.modules.ebean.EbeanDataSourceWrapper;
import play.modules.ebean.EbeanEnhancer;
import play.modules.ebean.EbeanModelAdapter;

public class EbeanPlugin
extends PlayPlugin {
    public static EbeanServer defaultServer;

    public static EbeanServer createServer(String name, DataSource dataSource) {
        EbeanServer result = null;
        ServerConfig cfg = new ServerConfig();
        cfg.loadFromProperties();
        cfg.setName(name);
        cfg.setClasses(Play.classloader.getAllClasses());
        cfg.setDataSource((DataSource)new EbeanDataSourceWrapper(dataSource));
        cfg.setRegister("default".equals(name));
        cfg.setDefaultServer("default".equals(name));
        cfg.add((BeanPersistController)new EbeanModelAdapter());
        try {
            result = EbeanServerFactory.create((ServerConfig)cfg);
        }
        catch (Throwable t) {
            Logger.error((String)"Failed to create ebean server", (Object[])new Object[]{t});
        }
        return result;
    }

    public void onLoad() {
        for (PlayPlugin plugin : Play.plugins) {
            if (!(plugin instanceof JPAPlugin)) continue;
            Play.plugins.remove(plugin);
            break;
        }
    }

    public void onApplicationStart() {
        if (DB.datasource != null) {
            defaultServer = EbeanPlugin.createServer("default", DB.datasource);
        }
    }

    public void beforeInvocation() {
        EbeanContext.set(defaultServer, new Object[0]);
    }

    public void invocationFinally() {
        EbeanContext.set(null, new Object[0]);
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        ((EbeanEnhancer)((Object)EbeanEnhancer.class.newInstance())).enhanceThisClass(applicationClass);
    }
}

