/*
 * Decompiled with CFR 0.152.
 */
package play.modules.ebean;

import com.avaje.ebean.enhance.agent.AlreadyEnhancedException;
import com.avaje.ebean.enhance.agent.ClassAdapterDetectEnhancement;
import com.avaje.ebean.enhance.agent.ClassAdapterTransactional;
import com.avaje.ebean.enhance.agent.ClassAdpaterEntity;
import com.avaje.ebean.enhance.agent.ClassBytesReader;
import com.avaje.ebean.enhance.agent.ClassPathClassBytesReader;
import com.avaje.ebean.enhance.agent.EnhanceContext;
import com.avaje.ebean.enhance.agent.NoEnhancementRequiredException;
import com.avaje.ebean.enhance.agent.UrlPathHelper;
import com.avaje.ebean.enhance.asm.ClassReader;
import com.avaje.ebean.enhance.asm.ClassVisitor;
import java.io.PrintStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import play.modules.ebean.PlayAwareClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HackedTransformer
implements ClassFileTransformer {
    private static final int CLASS_WRITER_COMPUTEFLAGS = 3;
    private final EnhanceContext enhanceContext;
    private boolean performDetect;
    private boolean transformTransactional;
    private boolean transformEntityBeans;

    public static void premain(String agentArgs, Instrumentation inst) {
        HackedTransformer t = new HackedTransformer("", agentArgs);
        inst.addTransformer(t);
        if (t.getLogLevel() > 0) {
            System.out.println("premain loading Transformer args:" + agentArgs);
        }
    }

    public HackedTransformer(String extraClassPath, String agentArgs) {
        this(HackedTransformer.parseClassPaths(extraClassPath), agentArgs);
    }

    public HackedTransformer(URL[] extraClassPath, String agentArgs) {
        this((ClassBytesReader)new ClassPathClassBytesReader(extraClassPath), agentArgs);
    }

    public HackedTransformer(ClassBytesReader r, String agentArgs) {
        this.enhanceContext = new EnhanceContext(r, false, agentArgs);
        this.performDetect = this.enhanceContext.getPropertyBoolean("detect", true);
        this.transformTransactional = this.enhanceContext.getPropertyBoolean("transactional", true);
        this.transformEntityBeans = this.enhanceContext.getPropertyBoolean("entity", true);
    }

    public void setLogout(PrintStream logout) {
        this.enhanceContext.setLogout(logout);
    }

    public void log(int level, String msg) {
        this.enhanceContext.log(level, msg);
    }

    public int getLogLevel() {
        return this.enhanceContext.getLogLevel();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (this.enhanceContext.isIgnoreClass(className)) {
                return null;
            }
            ClassAdapterDetectEnhancement detect = null;
            if (this.performDetect) {
                this.enhanceContext.log(5, "performing detection on " + className);
                detect = this.detect(loader, classfileBuffer);
            }
            if (detect == null) {
                this.enhanceContext.log(1, "no detection so enhancing entity " + className);
                return this.entityEnhancement(loader, classfileBuffer);
            }
            if (this.transformEntityBeans && detect.isEntity()) {
                if (detect.isEnhancedEntity()) {
                    detect.log(1, "already enhanced entity");
                } else {
                    detect.log(2, "performing entity transform");
                    return this.entityEnhancement(loader, classfileBuffer);
                }
            }
            if (this.transformTransactional && detect.isTransactional()) {
                if (detect.isEnhancedTransactional()) {
                    detect.log(1, "already enhanced transactional");
                } else {
                    detect.log(2, "performing transactional transform");
                    return this.transactionalEnhancement(loader, classfileBuffer);
                }
            }
            return null;
        }
        catch (NoEnhancementRequiredException e) {
            this.log(8, "No Enhancement required " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            this.enhanceContext.log((Throwable)e);
            return null;
        }
    }

    private byte[] entityEnhancement(ClassLoader loader, byte[] classfileBuffer) {
        ClassReader cr = new ClassReader(classfileBuffer);
        PlayAwareClassWriter cw = new PlayAwareClassWriter(3);
        ClassAdpaterEntity ca = new ClassAdpaterEntity((ClassVisitor)cw, loader, this.enhanceContext);
        try {
            cr.accept((ClassVisitor)ca, 0);
            if (ca.isLog(1)) {
                ca.logEnhanced();
            }
            if (this.enhanceContext.isReadOnly()) {
                return null;
            }
            return cw.toByteArray();
        }
        catch (AlreadyEnhancedException e) {
            if (ca.isLog(1)) {
                ca.log("already enhanced entity");
            }
            return null;
        }
        catch (NoEnhancementRequiredException e) {
            if (ca.isLog(2)) {
                ca.log("skipping... no enhancement required");
            }
            return null;
        }
    }

    private byte[] transactionalEnhancement(ClassLoader loader, byte[] classfileBuffer) {
        ClassReader cr = new ClassReader(classfileBuffer);
        PlayAwareClassWriter cw = new PlayAwareClassWriter(3);
        ClassAdapterTransactional ca = new ClassAdapterTransactional((ClassVisitor)cw, loader, this.enhanceContext);
        try {
            cr.accept((ClassVisitor)ca, 0);
            if (ca.isLog(1)) {
                ca.log("enhanced");
            }
            if (this.enhanceContext.isReadOnly()) {
                return null;
            }
            return cw.toByteArray();
        }
        catch (AlreadyEnhancedException e) {
            if (ca.isLog(1)) {
                ca.log("already enhanced");
            }
            return null;
        }
        catch (NoEnhancementRequiredException e) {
            if (ca.isLog(0)) {
                ca.log("skipping... no enhancement required");
            }
            return null;
        }
    }

    public static URL[] parseClassPaths(String extraClassPath) {
        if (extraClassPath == null) {
            return new URL[0];
        }
        String[] stringPaths = extraClassPath.split(";");
        return UrlPathHelper.convertToUrl((String[])stringPaths);
    }

    private ClassAdapterDetectEnhancement detect(ClassLoader classLoader, byte[] classfileBuffer) {
        ClassAdapterDetectEnhancement detect = new ClassAdapterDetectEnhancement(classLoader, this.enhanceContext);
        ClassReader cr = new ClassReader(classfileBuffer);
        cr.accept((ClassVisitor)detect, 7);
        return detect;
    }
}

