/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.PropertyExpression;
import com.avaje.ebean.config.PropertyMap;
import com.avaje.ebean.config.PropertyMapLoader;
import com.avaje.ebeaninternal.api.ClassUtil;
import java.util.Map;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobalProperties {
    private static PropertyMap globalMap;
    private static boolean skipPrimaryServer;

    public static synchronized void setSkipPrimaryServer(boolean skip) {
        skipPrimaryServer = skip;
    }

    public static synchronized boolean isSkipPrimaryServer() {
        return skipPrimaryServer;
    }

    public static String evaluateExpressions(String val) {
        return PropertyExpression.eval(val);
    }

    public static synchronized void setServletContext(ServletContext servletContext) {
        PropertyMapLoader.setServletContext(servletContext);
    }

    public static synchronized ServletContext getServletContext() {
        return PropertyMapLoader.getServletContext();
    }

    private static void initPropertyMap() {
        String loaderCn;
        String fileName = System.getenv("EBEAN_PROPS_FILE");
        if (fileName == null && (fileName = System.getProperty("ebean.props.file")) == null) {
            fileName = "ebean.properties";
        }
        if ((globalMap = PropertyMapLoader.load(null, fileName)) == null) {
            globalMap = new PropertyMap();
        }
        if ((loaderCn = globalMap.get("ebean.properties.loader")) != null) {
            try {
                Runnable r = (Runnable)ClassUtil.newInstance(loaderCn);
                r.run();
            }
            catch (Exception e) {
                String m = "Error creating or running properties loader " + loaderCn;
                throw new RuntimeException(m, e);
            }
        }
    }

    private static synchronized PropertyMap getPropertyMap() {
        if (globalMap == null) {
            GlobalProperties.initPropertyMap();
        }
        return globalMap;
    }

    public static synchronized String get(String key, String defaultValue) {
        return GlobalProperties.getPropertyMap().get(key, defaultValue);
    }

    public static synchronized int getInt(String key, int defaultValue) {
        return GlobalProperties.getPropertyMap().getInt(key, defaultValue);
    }

    public static synchronized boolean getBoolean(String key, boolean defaultValue) {
        return GlobalProperties.getPropertyMap().getBoolean(key, defaultValue);
    }

    public static synchronized String put(String key, String defaultValue) {
        return GlobalProperties.getPropertyMap().put(key, defaultValue);
    }

    public static synchronized void putAll(Map<String, String> keyValueMap) {
        GlobalProperties.getPropertyMap().putAll(keyValueMap);
    }
}

