/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

final class PropertyExpression {
    private static final Logger logger = Logger.getLogger(PropertyExpression.class.getName());
    private static final String JAVA_COMP_ENV = "java:comp/env/";
    private static String START = "${";
    private static String END = "}";

    private PropertyExpression() {
    }

    static String eval(String val) {
        int ep;
        if (val == null) {
            return null;
        }
        int sp = val.indexOf(START);
        if (sp > -1 && (ep = val.indexOf(END, sp + 1)) > -1) {
            return PropertyExpression.eval(val, sp, ep);
        }
        return val;
    }

    private static String evaluateExpression(String exp) {
        String val;
        if (PropertyExpression.isJndiExpression(exp) && (val = PropertyExpression.getJndiProperty(exp)) != null) {
            return val;
        }
        val = System.getenv(exp);
        if (val == null) {
            val = System.getProperty(exp);
        }
        if (val != null) {
            return val;
        }
        String msg = "Unable to evaluate expression [" + exp + "]";
        logger.warning(msg);
        return exp;
    }

    private static String eval(String val, int sp, int ep) {
        StringBuilder sb = new StringBuilder();
        sb.append(val.substring(0, sp));
        String cal = PropertyExpression.evalExpression(val, sp, ep);
        sb.append(cal);
        PropertyExpression.eval(val, ep + 1, sb);
        return sb.toString();
    }

    private static void eval(String val, int startPos, StringBuilder sb) {
        int sp;
        if (startPos < val.length() && (sp = val.indexOf(START, startPos)) > -1) {
            sb.append(val.substring(startPos, sp));
            int ep = val.indexOf(END, sp + 1);
            if (ep > -1) {
                String cal = PropertyExpression.evalExpression(val, sp, ep);
                sb.append(cal);
                PropertyExpression.eval(val, ep + 1, sb);
                return;
            }
        }
        sb.append(val.substring(startPos));
    }

    private static String evalExpression(String val, int sp, int ep) {
        String exp = val.substring(sp + START.length(), ep);
        return PropertyExpression.evaluateExpression(exp);
    }

    private static boolean isJndiExpression(String exp) {
        if (exp.startsWith("JNDI:")) {
            return true;
        }
        return exp.startsWith("jndi:");
    }

    private static String getJndiProperty(String key) {
        try {
            key = key.substring(5);
            return (String)PropertyExpression.getJndiObject(key);
        }
        catch (NamingException ex) {
            return null;
        }
    }

    private static Object getJndiObject(String key) throws NamingException {
        InitialContext ctx = new InitialContext();
        return ctx.lookup(JAVA_COMP_ENV + key);
    }
}

