/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleExpression
extends AbstractExpression {
    private static final long serialVersionUID = -382881395755603790L;
    private final Op type;
    private final Object value;

    public SimpleExpression(String propertyName, Op type, Object value) {
        super(propertyName);
        this.type = type;
        this.value = value;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                Object[] ids = prop.getAssocOneIdValues(this.value);
                if (ids != null) {
                    for (int i = 0; i < ids.length; ++i) {
                        request.addBindValue(ids[i]);
                    }
                }
                return;
            }
            if (prop.isDbEncrypted()) {
                String encryptKey = prop.getBeanProperty().getEncryptKey().getStringValue();
                request.addBindValue(encryptKey);
            } else if (prop.isLocalEncrypted()) {
                // empty if block
            }
        }
        request.addBindValue(this.value);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                request.append(prop.getAssocOneIdExpr(this.propertyName, this.type.bind()));
                return;
            }
            if (prop.isDbEncrypted()) {
                String dsql = prop.getBeanProperty().getDecryptSql();
                request.append(dsql).append(this.type.bind());
                return;
            }
        }
        request.append(this.propertyName).append(this.type.bind());
    }

    @Override
    public int queryAutoFetchHash() {
        int hc = SimpleExpression.class.getName().hashCode();
        hc = hc * 31 + this.propertyName.hashCode();
        hc = hc * 31 + this.type.name().hashCode();
        return hc;
    }

    @Override
    public int queryPlanHash(BeanQueryRequest<?> request) {
        return this.queryAutoFetchHash();
    }

    @Override
    public int queryBindHash() {
        return this.value.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Op {
        EQ(" = ? "),
        NOT_EQ(" <> ? "),
        LT(" < ? "),
        LT_EQ(" <= ? "),
        GT(" > ? "),
        GT_EQ(" >= ? ");

        String exp;

        private Op(String exp) {
            this.exp = exp;
        }

        public String bind() {
            return this.exp;
        }
    }
}

