/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.jmx;

import com.avaje.ebean.AdminLogging;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.jmx.MAdminLoggingMBean;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;

public class MAdminLogging
implements MAdminLoggingMBean,
AdminLogging {
    public static final int NONE = AdminLogging.LogLevelStmt.NONE.ordinal();
    public static final int SQL = AdminLogging.LogLevelStmt.SQL.ordinal();
    public static final int BIND = AdminLogging.LogLevelStmt.BINDING.ordinal();
    public static final int SUMMARY = AdminLogging.LogLevelStmt.SUMMARY.ordinal();
    private final TransactionManager transactionManager;
    AdminLogging.LogLevelStmt queryLevel;
    int ordinalQuery;
    AdminLogging.LogLevelStmt sqlQueryLevel;
    int ordinalSqlQuery;
    AdminLogging.LogLevelStmt iudLevel;
    int ordinalIud;
    boolean debugSql;
    boolean debugLazyLoad;

    public MAdminLogging(ServerConfig serverConfig, TransactionManager txManager) {
        this.transactionManager = txManager;
        this.debugSql = serverConfig.isDebugSql();
        this.debugLazyLoad = serverConfig.isDebugLazyLoad();
        this.sqlQueryLevel = serverConfig.getLoggingLevelSqlQuery();
        this.ordinalSqlQuery = this.sqlQueryLevel == null ? 0 : this.sqlQueryLevel.ordinal();
        this.queryLevel = serverConfig.getLoggingLevelQuery();
        this.ordinalQuery = this.queryLevel == null ? 0 : this.queryLevel.ordinal();
        this.iudLevel = serverConfig.getLoggingLevelIud();
        this.ordinalIud = this.iudLevel == null ? 0 : this.iudLevel.ordinal();
    }

    public void setLoggingLevel(AdminLogging.LogLevel txLogLevel) {
        this.transactionManager.setTransactionLogLevel(txLogLevel);
    }

    public AdminLogging.LogLevel getLoggingLevel() {
        return this.transactionManager.getTransactionLogLevel();
    }

    public boolean isLogQuery(int level) {
        return this.ordinalQuery >= level;
    }

    public boolean isLogSqlQuery(int level) {
        return this.ordinalSqlQuery >= level;
    }

    public boolean isLogIud(int level) {
        return this.ordinalIud >= level;
    }

    public boolean isLogBind(AdminLogging.LogLevelStmt l) {
        return l.ordinal() >= AdminLogging.LogLevelStmt.BINDING.ordinal();
    }

    public boolean isLogSummary(AdminLogging.LogLevelStmt l) {
        return l.ordinal() >= AdminLogging.LogLevelStmt.SUMMARY.ordinal();
    }

    public AdminLogging.LogLevelStmt getLoggingLevelQuery() {
        return this.queryLevel;
    }

    public void setLoggingLevelQuery(AdminLogging.LogLevelStmt queryLevel) {
        this.queryLevel = queryLevel;
        this.ordinalQuery = queryLevel == null ? 0 : queryLevel.ordinal();
    }

    public AdminLogging.LogLevelStmt getLoggingLevelSqlQuery() {
        return this.sqlQueryLevel;
    }

    public void setLoggingLevelSqlQuery(AdminLogging.LogLevelStmt sqlQueryLevel) {
        this.sqlQueryLevel = sqlQueryLevel;
        this.ordinalSqlQuery = sqlQueryLevel == null ? 0 : sqlQueryLevel.ordinal();
    }

    public int getIudOrdinal() {
        return this.ordinalIud;
    }

    public AdminLogging.LogLevelStmt getLoggingLevelIud() {
        return this.iudLevel;
    }

    public void setLoggingLevelIud(AdminLogging.LogLevelStmt iudLevel) {
        this.iudLevel = iudLevel;
        this.ordinalIud = iudLevel == null ? 0 : iudLevel.ordinal();
    }

    public boolean isDebugGeneratedSql() {
        return this.debugSql;
    }

    public void setDebugGeneratedSql(boolean debugSql) {
        this.debugSql = debugSql;
    }

    public boolean isDebugLazyLoad() {
        return this.debugLazyLoad;
    }

    public void setDebugLazyLoad(boolean debugLazyLoad) {
        this.debugLazyLoad = debugLazyLoad;
    }
}

