/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.ldap.expression;

import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.ldap.expression.LdAbstractExpression;
import com.avaje.ebeaninternal.server.ldap.expression.LdEscape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LdLikeExpression
extends LdAbstractExpression {
    private static final long serialVersionUID = 4091359751840929076L;
    private final String value;

    public LdLikeExpression(String propertyName, String value) {
        super(propertyName);
        this.value = value;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String escapedValue = this.value == null ? "*" : LdEscape.forLike(this.value);
        String parsed = request.parseDeploy(this.propertyName);
        request.append("(").append(parsed).append("=").append(escapedValue).append(")");
    }

    @Override
    public int queryAutoFetchHash() {
        int hc = LdLikeExpression.class.getName().hashCode();
        hc = hc * 31 + this.propertyName.hashCode();
        return hc;
    }

    @Override
    public int queryPlanHash(BeanQueryRequest<?> request) {
        return this.queryAutoFetchHash();
    }

    @Override
    public int queryBindHash() {
        return this.value.hashCode();
    }
}

