/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebean.CallableSql;
import com.avaje.ebean.Query;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.Update;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.config.ldap.LdapContextFactory;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.SpiUpdate;
import com.avaje.ebeaninternal.server.core.ConcurrencyMode;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.core.PersistRequestCallableSql;
import com.avaje.ebeaninternal.server.core.PersistRequestOrmUpdate;
import com.avaje.ebeaninternal.server.core.PersistRequestUpdateSql;
import com.avaje.ebeaninternal.server.core.Persister;
import com.avaje.ebeaninternal.server.core.PstmtBatch;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.deploy.BeanManager;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.IntersectionRow;
import com.avaje.ebeaninternal.server.deploy.ManyType;
import com.avaje.ebeaninternal.server.jmx.MAdminLogging;
import com.avaje.ebeaninternal.server.ldap.DefaultLdapPersister;
import com.avaje.ebeaninternal.server.ldap.LdapPersistBeanRequest;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.persist.DefaultPersistExecute;
import com.avaje.ebeaninternal.server.persist.DeleteUnloadedForeignKeys;
import com.avaje.ebeaninternal.server.persist.DmlUtil;
import com.avaje.ebeaninternal.server.persist.PersistExecute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPersister
implements Persister {
    private static final Logger logger = Logger.getLogger(DefaultPersister.class.getName());
    private final PersistExecute persistExecute;
    private final DefaultLdapPersister ldapPersister;
    private final SpiEbeanServer server;
    private final BeanDescriptorManager beanDescriptorManager;

    public DefaultPersister(SpiEbeanServer server, boolean validate, MAdminLogging logControl, Binder binder, BeanDescriptorManager descMgr, PstmtBatch pstmtBatch, LdapContextFactory contextFactory) {
        this.server = server;
        this.beanDescriptorManager = descMgr;
        this.persistExecute = new DefaultPersistExecute(validate, logControl, binder, pstmtBatch);
        this.ldapPersister = new DefaultLdapPersister(contextFactory);
    }

    @Override
    public int executeCallable(CallableSql callSql, Transaction t) {
        PersistRequestCallableSql request = new PersistRequestCallableSql(this.server, callSql, (SpiTransaction)t, this.persistExecute);
        try {
            request.initTransIfRequired();
            int rc = request.executeOrQueue();
            request.commitTransIfRequired();
            return rc;
        }
        catch (RuntimeException e) {
            request.rollbackTransIfRequired();
            throw e;
        }
    }

    @Override
    public int executeOrmUpdate(Update<?> update, Transaction t) {
        SpiUpdate ormUpdate = (SpiUpdate)update;
        BeanManager<?> mgr = this.beanDescriptorManager.getBeanManager(ormUpdate.getBeanType());
        if (mgr == null) {
            String msg = "No BeanManager found for type [" + ormUpdate.getBeanType() + "]. Is it an entity?";
            throw new PersistenceException(msg);
        }
        PersistRequestOrmUpdate request = new PersistRequestOrmUpdate(this.server, mgr, ormUpdate, (SpiTransaction)t, this.persistExecute);
        try {
            request.initTransIfRequired();
            int rc = request.executeOrQueue();
            request.commitTransIfRequired();
            return rc;
        }
        catch (RuntimeException e) {
            request.rollbackTransIfRequired();
            throw e;
        }
    }

    @Override
    public int executeSqlUpdate(SqlUpdate updSql, Transaction t) {
        PersistRequestUpdateSql request = new PersistRequestUpdateSql(this.server, updSql, (SpiTransaction)t, this.persistExecute);
        try {
            request.initTransIfRequired();
            int rc = request.executeOrQueue();
            request.commitTransIfRequired();
            return rc;
        }
        catch (RuntimeException e) {
            request.rollbackTransIfRequired();
            throw e;
        }
    }

    private void deleteRecurse(Object detailBean, Transaction t) {
        this.server.delete(detailBean, t);
    }

    @Override
    public void forceUpdate(Object bean, Set<String> updateProps, Transaction t) {
        BeanManager<Object> mgr;
        if (bean == null) {
            throw new NullPointerException(Message.msg("bean.isnull"));
        }
        if (bean instanceof EntityBean) {
            EntityBeanIntercept ebi = ((EntityBean)bean)._ebean_getIntercept();
            if (ebi.isDirty()) {
                PersistRequestBean<Object> req = this.createRequest(bean, t, null);
                try {
                    req.initTransIfRequired();
                    this.update(req);
                    req.commitTransIfRequired();
                    return;
                }
                catch (RuntimeException ex) {
                    req.rollbackTransIfRequired();
                    throw ex;
                }
            }
            if (ebi.isLoaded()) {
                return;
            }
            if (updateProps == null) {
                updateProps = ebi.getLoadedProps();
            }
        }
        if ((mgr = this.getBeanManager(bean)) == null) {
            throw new PersistenceException(this.errNotRegistered(bean.getClass()));
        }
        this.forceUpdate(bean, t, null, mgr, updateProps);
    }

    private void forceUpdate(Object bean, Transaction t, Object parentBean, BeanManager<?> mgr, Set<String> updateProps) {
        String verName;
        BeanDescriptor<?> descriptor = mgr.getBeanDescriptor();
        ConcurrencyMode mode = descriptor.determineConcurrencyMode(bean);
        if (updateProps == null) {
            updateProps = descriptor.determineLoadedProperties(bean);
        } else if (updateProps.isEmpty()) {
            updateProps = null;
        } else if (ConcurrencyMode.VERSION.equals((Object)mode) && !updateProps.contains(verName = descriptor.firstVersionProperty().getName())) {
            updateProps = new HashSet<String>(updateProps);
            updateProps.add(verName);
        }
        PersistRequestBean req = descriptor.isLdapEntityType() ? new LdapPersistBeanRequest<Object>(this.server, bean, parentBean, mgr, this.ldapPersister, updateProps, mode) : new PersistRequestBean<Object>(this.server, bean, parentBean, mgr, (SpiTransaction)t, this.persistExecute, updateProps, mode);
        try {
            req.initTransIfRequired();
            this.update(req);
            req.commitTransIfRequired();
        }
        catch (RuntimeException ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public void save(Object bean, Transaction t) {
        this.saveRecurse(bean, t, null);
    }

    private void saveRecurse(Object bean, Transaction t, Object parentBean) {
        if (bean == null) {
            throw new NullPointerException(Message.msg("bean.isnull"));
        }
        if (!(bean instanceof EntityBean)) {
            this.saveVanillaRecurse(bean, t, parentBean);
            return;
        }
        PersistRequestBean<Object> req = this.createRequest(bean, t, parentBean);
        try {
            req.initTransIfRequired();
            this.saveEnhanced(req);
            req.commitTransIfRequired();
        }
        catch (RuntimeException ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
    }

    private void saveEnhanced(PersistRequestBean<?> request) {
        EntityBeanIntercept intercept = request.getEntityBeanIntercept();
        if (intercept.isReference()) {
            if (request.isPersistCascade()) {
                intercept.setLoaded();
                this.saveAssocMany(false, request);
                intercept.setReference();
            }
        } else if (intercept.isLoaded()) {
            this.update(request);
        } else {
            this.insert(request);
        }
    }

    private void saveVanillaRecurse(Object bean, Transaction t, Object parentBean) {
        BeanManager<Object> mgr = this.getBeanManager(bean);
        if (mgr == null) {
            throw new RuntimeException("No Mgr found for " + bean + " " + bean.getClass());
        }
        if (mgr.getBeanDescriptor().isVanillaInsert(bean)) {
            this.saveVanillaInsert(bean, t, parentBean, mgr);
        } else {
            this.forceUpdate(bean, t, parentBean, mgr, null);
        }
    }

    private void saveVanillaInsert(Object bean, Transaction t, Object parentBean, BeanManager<?> mgr) {
        PersistRequestBean<?> req = this.createRequest(bean, t, parentBean, mgr);
        try {
            req.initTransIfRequired();
            this.insert(req);
            req.commitTransIfRequired();
        }
        catch (RuntimeException ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
    }

    private void insert(PersistRequestBean<?> request) {
        request.setType(PersistRequest.Type.INSERT);
        if (request.isPersistCascade()) {
            this.saveAssocOne(request);
        }
        this.setIdGenValue(request);
        request.executeOrQueue();
        if (request.isPersistCascade()) {
            this.saveAssocMany(true, request);
        }
    }

    private void update(PersistRequestBean<?> request) {
        request.setType(PersistRequest.Type.UPDATE);
        if (request.isPersistCascade()) {
            this.saveAssocOne(request);
        }
        if (request.isDirty()) {
            request.executeOrQueue();
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(Message.msg("persist.update.skipped", request.getBean()));
        }
        if (request.isPersistCascade()) {
            this.saveAssocMany(false, request);
        }
    }

    @Override
    public void delete(Object bean, Transaction t) {
        PersistRequestBean<Object> req = this.createRequest(bean, t, null);
        if (req.isRegistered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("skipping delete on alreadyRegistered " + bean);
            }
            return;
        }
        req.setType(PersistRequest.Type.DELETE);
        try {
            req.initTransIfRequired();
            this.delete(req);
            req.commitTransIfRequired();
        }
        catch (RuntimeException ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
    }

    private void deleteList(List<?> beanList, Transaction t) {
        for (int i = 0; i < beanList.size(); ++i) {
            Object bean = beanList.get(i);
            this.delete(bean, t);
        }
    }

    @Override
    public void deleteMany(Class<?> beanType, Collection<?> ids, Transaction transaction) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(beanType);
        ArrayList<Object> idList = new ArrayList<Object>(ids.size());
        Iterator<?> it = ids.iterator();
        while (it.hasNext()) {
            Object id = descriptor.convertId(it.next());
            idList.add(id);
        }
        this.delete(descriptor, null, idList, transaction);
    }

    @Override
    public int delete(Class<?> beanType, Object id, Transaction transaction) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(beanType);
        id = descriptor.convertId(id);
        return this.delete(descriptor, id, null, transaction);
    }

    private int delete(BeanDescriptor<?> descriptor, Object id, List<Object> idList, Transaction transaction) {
        BeanPropertyAssocOne<?>[] propImportDelete;
        SpiTransaction t = (SpiTransaction)transaction;
        if (t.isPersistCascade() && (propImportDelete = descriptor.propertiesOneImportedDelete()).length > 0) {
            Query<?> q = this.deleteRequiresQuery(descriptor, propImportDelete);
            if (idList != null) {
                q.where().idIn(idList);
                t.log("-- Deleting list of " + descriptor.getName() + " requires fetch of foreign key values");
                List<?> beanList = this.server.findList(q, (Transaction)t);
                this.deleteList(beanList, t);
                return beanList.size();
            }
            q.where().idEq(id);
            t.log("-- Delete of " + descriptor.getName() + " id:" + id + " requires fetch of foreign key values");
            Object bean = this.server.findUnique(q, (Transaction)t);
            if (bean == null) {
                return 0;
            }
            this.delete(bean, t);
            return 1;
        }
        if (t.isPersistCascade()) {
            BeanPropertyAssocOne<?>[] expOnes = descriptor.propertiesOneExportedDelete();
            for (int i = 0; i < expOnes.length; ++i) {
                SqlUpdate sqlDelete = expOnes[i].deleteByParentId(id, idList);
                this.executeSqlUpdate(sqlDelete, t);
            }
            BeanPropertyAssocMany<?>[] manys = descriptor.propertiesManyDelete();
            for (int i = 0; i < manys.length; ++i) {
                SqlUpdate sqlDelete = manys[i].deleteByParentId(id, idList);
                this.executeSqlUpdate(sqlDelete, t);
            }
        }
        BeanPropertyAssocMany<?>[] manys = descriptor.propertiesManyToMany();
        for (int i = 0; i < manys.length; ++i) {
            SqlUpdate sqlDelete = manys[i].deleteByParentId(id, idList);
            this.executeSqlUpdate(sqlDelete, t);
        }
        SqlUpdate deleteById = descriptor.deleteById(id, idList);
        return this.executeSqlUpdate(deleteById, t);
    }

    private Query<?> deleteRequiresQuery(BeanDescriptor<?> desc, BeanPropertyAssocOne<?>[] propImportDelete) {
        Query<?> q = this.server.createQuery(desc.getBeanType());
        StringBuilder sb = new StringBuilder(30);
        for (int i = 0; i < propImportDelete.length; ++i) {
            sb.append(propImportDelete[i].getName()).append(",");
        }
        q.setAutofetch(false);
        q.select(sb.toString());
        return q;
    }

    private void delete(PersistRequestBean<?> request) {
        DeleteUnloadedForeignKeys unloadedForeignKeys = null;
        if (request.isPersistCascade()) {
            request.registerBean();
            this.deleteAssocMany(request);
            request.unregisterBean();
            unloadedForeignKeys = this.getDeleteUnloadedForeignKeys(request);
            if (unloadedForeignKeys != null) {
                unloadedForeignKeys.queryForeignKeys(this.server, request);
            }
        }
        request.executeOrQueue();
        if (request.isPersistCascade()) {
            this.deleteAssocOne(request);
            if (unloadedForeignKeys != null) {
                unloadedForeignKeys.deleteAssocOne(this.server, request);
            }
        }
    }

    private void saveAssocMany(boolean insertedParent, PersistRequestBean<?> request) {
        Object parentBean = request.getBean();
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        Transaction t = request.getTransaction();
        BeanPropertyAssocOne<?>[] expOnes = desc.propertiesOneExportedSave();
        for (int i = 0; i < expOnes.length; ++i) {
            Object detailBean;
            BeanPropertyAssocOne<?> prop = expOnes[i];
            if (!request.isLoadedProperty(prop) || (detailBean = prop.getValue(parentBean)) == null || prop.isSaveRecurseSkippable(detailBean)) continue;
            t.depth(1);
            this.saveRecurse(detailBean, t, parentBean);
            t.depth(-1);
        }
        BeanPropertyAssocMany<?>[] manys = desc.propertiesManySave();
        for (int i = 0; i < manys.length; ++i) {
            this.saveMany(insertedParent, manys[i], parentBean, (SpiTransaction)t, manys[i].getCascadeInfo().isSave());
        }
    }

    private void saveMany(boolean insertedParent, BeanPropertyAssocMany<?> many, Object parentBean, SpiTransaction t, boolean cascade) {
        if (many.isManyToMany()) {
            if (cascade) {
                this.saveAssocManyDetails(insertedParent, many, parentBean, t);
                this.saveAssocManyIntersection(insertedParent, many, parentBean, t);
            }
        } else {
            if (cascade) {
                this.saveAssocManyDetails(insertedParent, many, parentBean, t);
            }
            if (BeanCollection.ModifyListenMode.REMOVALS.equals((Object)many.getModifyListenMode())) {
                this.removeAssocManyPrivateOwned(many, parentBean, t);
            }
        }
    }

    private void removeAssocManyPrivateOwned(BeanPropertyAssocMany<?> prop, Object parentBean, SpiTransaction t) {
        BeanCollection c;
        Set modifyRemovals;
        Object details = prop.getValueUnderlying(parentBean);
        if (details instanceof BeanCollection && (modifyRemovals = (c = (BeanCollection)details).getModifyRemovals()) != null && !modifyRemovals.isEmpty()) {
            t.depth(1);
            for (Object removedBean : modifyRemovals) {
                this.deleteRecurse(removedBean, t);
            }
            t.depth(-1);
        }
    }

    private void saveAssocManyDetails(boolean insertedParent, BeanPropertyAssocMany<?> prop, Object parentBean, SpiTransaction t) {
        Object details = prop.getValueUnderlying(parentBean);
        Collection<?> collection = this.getDetailsIterator(details);
        if (collection != null) {
            if (insertedParent) {
                prop.getTargetDescriptor().preAllocateIds(collection.size());
            }
            t.depth(1);
            boolean isMap = ManyType.JAVA_MAP.equals(prop.getManyType());
            Object mapKeyValue = null;
            boolean saveSkippable = prop.isSaveRecurseSkippable();
            boolean skipSavingThisBean = false;
            for (Object detailBean : collection) {
                if (isMap) {
                    Map.Entry entry = (Map.Entry)detailBean;
                    mapKeyValue = entry.getKey();
                    detailBean = entry.getValue();
                }
                if (!prop.isManyToMany()) {
                    if (detailBean instanceof EntityBean) {
                        if (((EntityBean)detailBean)._ebean_getIntercept().isNewOrDirty()) {
                            prop.setJoinValuesToChild(parentBean, detailBean, mapKeyValue);
                        } else {
                            skipSavingThisBean = saveSkippable;
                        }
                    } else {
                        prop.setJoinValuesToChild(parentBean, detailBean, mapKeyValue);
                    }
                }
                if (skipSavingThisBean) {
                    skipSavingThisBean = false;
                    continue;
                }
                this.saveRecurse(detailBean, t, parentBean);
            }
            t.depth(-1);
        }
    }

    @Override
    public int deleteManyToManyAssociations(Object ownerBean, String propertyName, Transaction t) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(ownerBean.getClass());
        BeanPropertyAssocMany prop = (BeanPropertyAssocMany)descriptor.getBeanProperty(propertyName);
        return this.deleteAssocManyIntersection(ownerBean, prop, t);
    }

    @Override
    public void saveManyToManyAssociations(Object ownerBean, String propertyName, Transaction t) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(ownerBean.getClass());
        BeanPropertyAssocMany prop = (BeanPropertyAssocMany)descriptor.getBeanProperty(propertyName);
        this.saveAssocManyIntersection(false, prop, ownerBean, (SpiTransaction)t);
    }

    @Override
    public void saveAssociation(Object parentBean, String propertyName, Transaction t) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(parentBean.getClass());
        SpiTransaction trans = (SpiTransaction)t;
        BeanProperty prop = descriptor.getBeanProperty(propertyName);
        if (prop == null) {
            String msg = "Could not find property [" + propertyName + "] on bean " + parentBean.getClass();
            throw new PersistenceException(msg);
        }
        if (prop instanceof BeanPropertyAssocMany) {
            BeanPropertyAssocMany manyProp = (BeanPropertyAssocMany)prop;
            this.saveMany(false, manyProp, parentBean, (SpiTransaction)t, true);
        } else if (prop instanceof BeanPropertyAssocOne) {
            BeanPropertyAssocOne oneProp = (BeanPropertyAssocOne)prop;
            Object assocBean = oneProp.getValue(parentBean);
            int depth = oneProp.isOneToOneExported() ? 1 : -1;
            int revertDepth = -1 * depth;
            trans.depth(depth);
            this.saveRecurse(assocBean, t, parentBean);
            trans.depth(revertDepth);
        } else {
            String msg = "Expecting [" + prop.getFullBeanName() + "] to be a OneToMany, OneToOne, ManyToOne or ManyToMany property?";
            throw new PersistenceException(msg);
        }
    }

    private void saveAssocManyIntersection(boolean insertedParent, BeanPropertyAssocMany<?> prop, Object parentBean, SpiTransaction t) {
        IntersectionRow intRow;
        boolean vanillaCollection;
        Object value = prop.getValueUnderlying(parentBean);
        if (value == null) {
            return;
        }
        Collection additions = null;
        Set deletions = null;
        boolean bl = vanillaCollection = !(value instanceof BeanCollection);
        if (vanillaCollection || insertedParent) {
            if (value instanceof Map) {
                additions = ((Map)value).values();
            } else if (value instanceof Collection) {
                additions = (Collection)value;
            } else {
                String msg = "Unhandled ManyToMany type " + value.getClass().getName() + " for " + prop.getFullBeanName();
                throw new PersistenceException(msg);
            }
            if (!vanillaCollection) {
                ((BeanCollection)value).modifyReset();
            }
        } else {
            BeanCollection manyValue = (BeanCollection)value;
            additions = manyValue.getModifyAdditions();
            deletions = manyValue.getModifyRemovals();
            manyValue.modifyReset();
        }
        t.depth(1);
        if (additions != null && !additions.isEmpty()) {
            for (Object otherBean : additions) {
                if (deletions != null && deletions.remove(otherBean)) {
                    String m = "Inserting and Deleting same object? " + otherBean;
                    t.log(m);
                    logger.log(Level.WARNING, m);
                    continue;
                }
                if (!prop.hasImportedId(otherBean)) {
                    String msg = "ManyToMany bean " + otherBean + " does not have an Id value.";
                    throw new PersistenceException(msg);
                }
                intRow = prop.buildManyToManyMapBean(parentBean, otherBean);
                SqlUpdate sqlInsert = intRow.createInsert(this.server);
                t.log(sqlInsert.getSql());
                this.executeSqlUpdate(sqlInsert, t);
            }
        }
        if (deletions != null && !deletions.isEmpty()) {
            for (Object otherDelete : deletions) {
                intRow = prop.buildManyToManyMapBean(parentBean, otherDelete);
                SqlUpdate sqlDelete = intRow.createDelete(this.server);
                t.log(sqlDelete.getSql());
                this.executeSqlUpdate(sqlDelete, t);
            }
        }
        t.depth(-1);
    }

    private int deleteAssocManyIntersection(Object bean, BeanPropertyAssocMany<?> many, Transaction t) {
        IntersectionRow intRow = many.buildManyToManyDeleteChildren(bean);
        SqlUpdate sqlDelete = intRow.createDeleteChildren(this.server);
        t.log(sqlDelete.getSql());
        return this.executeSqlUpdate(sqlDelete, t);
    }

    private void deleteAssocMany(PersistRequestBean<?> request) {
        Transaction t = request.getTransaction();
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        Object parentBean = request.getBean();
        BeanPropertyAssocOne<?>[] expOnes = desc.propertiesOneExportedDelete();
        for (int i = 0; i < expOnes.length; ++i) {
            Object detailBean;
            BeanPropertyAssocOne<?> prop = expOnes[i];
            if (!request.isLoadedProperty(prop) || (detailBean = prop.getValue(parentBean)) == null) continue;
            t.depth(-1);
            this.deleteRecurse(detailBean, t);
            t.depth(1);
        }
        BeanPropertyAssocMany<?>[] manys = desc.propertiesManyDelete();
        for (int i = 0; i < manys.length; ++i) {
            Collection<?> collection;
            BeanCollection bc;
            Set modifyRemovals;
            if (manys[i].isManyToMany()) {
                this.deleteAssocManyIntersection(parentBean, manys[i], t);
                continue;
            }
            Object details = manys[i].getValueUnderlying(parentBean);
            if (BeanCollection.ModifyListenMode.REMOVALS.equals((Object)manys[i].getModifyListenMode()) && details instanceof BeanCollection && (modifyRemovals = (bc = (BeanCollection)details).getModifyRemovals()) != null && !modifyRemovals.isEmpty()) {
                t.depth(-1);
                for (Object detailBean : modifyRemovals) {
                    if (!manys[i].hasId(detailBean)) continue;
                    this.deleteRecurse(detailBean, t);
                }
                t.depth(1);
            }
            if ((collection = this.getDetailsIterator(details)) == null) {
                IntersectionRow intRow = manys[i].buildManyDeleteChildren(parentBean);
                SqlUpdate sqlDelete = intRow.createDelete(this.server);
                this.executeSqlUpdate(sqlDelete, t);
                continue;
            }
            t.depth(-1);
            for (Object detailBean : collection) {
                if (!manys[i].hasId(detailBean)) continue;
                this.deleteRecurse(detailBean, t);
            }
            t.depth(1);
        }
    }

    private void saveAssocOne(PersistRequestBean<?> request) {
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        BeanPropertyAssocOne<?>[] ones = desc.propertiesOneImportedSave();
        for (int i = 0; i < ones.length; ++i) {
            Object detailBean;
            BeanPropertyAssocOne<?> prop = ones[i];
            if (!request.isLoadedProperty(prop) || (detailBean = prop.getValue(request.getBean())) == null || this.isReference(detailBean) || request.isParent(detailBean) || prop.isSaveRecurseSkippable(detailBean)) continue;
            Transaction t = request.getTransaction();
            t.depth(-1);
            this.saveRecurse(detailBean, t, null);
            t.depth(1);
        }
    }

    private boolean isReference(Object bean) {
        return bean instanceof EntityBean && ((EntityBean)bean)._ebean_getIntercept().isReference();
    }

    private DeleteUnloadedForeignKeys getDeleteUnloadedForeignKeys(PersistRequestBean<?> request) {
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        DeleteUnloadedForeignKeys fkeys = null;
        BeanPropertyAssocOne<?>[] ones = desc.propertiesOneImportedDelete();
        for (int i = 0; i < ones.length; ++i) {
            if (request.isLoadedProperty(ones[i])) continue;
            if (fkeys == null) {
                fkeys = new DeleteUnloadedForeignKeys();
            }
            fkeys.add(ones[i]);
        }
        return fkeys;
    }

    private void deleteAssocOne(PersistRequestBean<?> request) {
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        BeanPropertyAssocOne<?>[] ones = desc.propertiesOneImportedDelete();
        for (int i = 0; i < ones.length; ++i) {
            Object detailBean;
            BeanPropertyAssocOne<?> prop = ones[i];
            if (!request.isLoadedProperty(prop) || (detailBean = prop.getValue(request.getBean())) == null || !prop.hasId(detailBean)) continue;
            this.deleteRecurse(detailBean, request.getTransaction());
        }
    }

    private void setIdGenValue(PersistRequestBean<?> request) {
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        if (!desc.isUseIdGenerator()) {
            return;
        }
        BeanProperty idProp = desc.getSingleIdProperty();
        if (idProp == null || idProp.isEmbedded()) {
            return;
        }
        Object bean = request.getBean();
        Object uid = idProp.getValue(bean);
        if (DmlUtil.isNullOrZero(uid)) {
            Object nextId = desc.nextId();
            desc.convertSetId(nextId, bean);
        }
    }

    private Collection<?> getDetailsIterator(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BeanCollection) {
            BeanCollection bc = (BeanCollection)o;
            if (!bc.isPopulated()) {
                return null;
            }
            return bc.getActualDetails();
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet();
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        String m = "expecting a Map or Collection but got [" + o.getClass().getName() + "]";
        throw new PersistenceException(m);
    }

    private <T> PersistRequestBean<T> createRequest(T bean, Transaction t, Object parentBean) {
        BeanManager<T> mgr = this.getBeanManager(bean);
        if (mgr == null) {
            throw new PersistenceException(this.errNotRegistered(bean.getClass()));
        }
        return this.createRequest(bean, t, parentBean, mgr);
    }

    private String errNotRegistered(Class<?> beanClass) {
        String msg = "The type [" + beanClass + "] is not a registered entity?";
        msg = msg + " If you don't explicitly list the entity classes to use Ebean will search for them in the classpath.";
        msg = msg + " If the entity is in a Jar check the ebean.search.jars property in ebean.properties file or check ServerConfig.addJar().";
        return msg;
    }

    private PersistRequestBean<?> createRequest(Object bean, Transaction t, Object parentBean, BeanManager<?> mgr) {
        if (mgr.isLdapEntityType()) {
            return new LdapPersistBeanRequest<Object>(this.server, bean, parentBean, mgr, this.ldapPersister);
        }
        return new PersistRequestBean<Object>(this.server, bean, parentBean, mgr, (SpiTransaction)t, this.persistExecute);
    }

    private <T> BeanManager<T> getBeanManager(T bean) {
        return this.beanDescriptorManager.getBeanManager(bean.getClass());
    }
}

