/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebean.Transaction;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteUnloadedForeignKeys {
    List<BeanPropertyAssocOne<?>> propList = new ArrayList(4);
    Object beanWithForeignKeys;

    public void add(BeanPropertyAssocOne<?> prop) {
        this.propList.add(prop);
    }

    public void queryForeignKeys(SpiEbeanServer server, PersistRequestBean<?> request) {
        BeanDescriptor<?> descriptor = request.getBeanDescriptor();
        SpiQuery q = (SpiQuery)server.createQuery(descriptor.getBeanType());
        Object id = request.getBeanId();
        StringBuilder sb = new StringBuilder(30);
        for (int i = 0; i < this.propList.size(); ++i) {
            sb.append(this.propList.get(i).getName()).append(",");
        }
        q.setPersistenceContext(new DefaultPersistenceContext());
        q.setAutofetch(false);
        q.select(sb.toString());
        q.where().idEq(id);
        Transaction t = request.getTransaction();
        t.log("-- Ebean fetching foreign key values for delete of " + descriptor.getName() + " id:" + id);
        this.beanWithForeignKeys = server.findUnique(q, t);
    }

    public void deleteAssocOne(SpiEbeanServer server, PersistRequestBean<?> request) {
        for (int i = 0; i < this.propList.size(); ++i) {
            BeanPropertyAssocOne<?> prop = this.propList.get(i);
            Object detailBean = prop.getValue(this.beanWithForeignKeys);
            if (detailBean == null || !prop.hasId(detailBean)) continue;
            server.delete(detailBean, request.getTransaction());
        }
    }
}

