/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.FetchConfig;
import com.avaje.ebean.FutureIds;
import com.avaje.ebean.FutureList;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.JoinConfig;
import com.avaje.ebean.OrderBy;
import com.avaje.ebean.PagingList;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryListener;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.bean.BeanCollectionTouched;
import com.avaje.ebean.bean.CallStack;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebean.meta.MetaAutoFetchStatistic;
import com.avaje.ebeaninternal.api.BindParams;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.autofetch.AutoFetchManager;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.DRawSqlSelect;
import com.avaje.ebeaninternal.server.deploy.DeployNamedQuery;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.query.CancelableQuery;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetailParser;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import com.avaje.ebeaninternal.util.DefaultExpressionList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOrmQuery<T>
implements SpiQuery<T> {
    private static final long serialVersionUID = 6838006264714672460L;
    private final Class<T> beanType;
    private final transient EbeanServer server;
    private transient BeanCollectionTouched beanCollectionTouched;
    private final transient ExpressionFactory expressionFactory;
    private transient ArrayList<EntityBean> contextAdditions;
    private transient QueryListener<T> queryListener;
    private transient TableJoin includeTableJoin;
    private transient AutoFetchManager autoFetchManager;
    private transient BeanDescriptor<?> beanDescriptor;
    private boolean cancelled;
    private transient CancelableQuery cancelableQuery;
    private String name;
    private Query.Type type;
    private SpiQuery.Mode mode = SpiQuery.Mode.NORMAL;
    private OrmQueryDetail detail;
    private int maxRows;
    private int firstRow;
    private String rawWhereClause;
    private OrderBy<T> orderBy;
    private String loadMode;
    private String loadDescription;
    private String generatedSql;
    private String query;
    private String additionalWhere;
    private String additionalHaving;
    private String lazyLoadProperty;
    private String lazyLoadManyPath;
    private Boolean vanillaMode;
    private boolean distinct;
    private boolean futureFetch;
    private boolean sharedInstance;
    private List<Object> partialIds;
    private int backgroundFetchAfter;
    private int timeout = -1;
    private String mapKey;
    private Object id;
    private BindParams bindParams;
    private DefaultExpressionList<T> whereExpressions;
    private DefaultExpressionList<T> havingExpressions;
    private int bufferFetchSizeHint;
    private boolean usageProfiling = true;
    private boolean loadBeanCache;
    private Boolean useBeanCache;
    private Boolean useQueryCache;
    private Boolean readOnly;
    private boolean sqlSelect;
    private Boolean autoFetch;
    private boolean autoFetchTuned;
    private ObjectGraphNode parentNode;
    private int queryPlanHash;
    private transient PersistenceContext persistenceContext;
    private ManyWhereJoins manyWhereJoins;
    private RawSql rawSql;

    public DefaultOrmQuery(Class<T> beanType, EbeanServer server, ExpressionFactory expressionFactory, String query) {
        this.beanType = beanType;
        this.server = server;
        this.expressionFactory = expressionFactory;
        this.detail = new OrmQueryDetail();
        this.name = "";
        if (query != null) {
            this.setQuery(query);
        }
    }

    public DefaultOrmQuery(Class<T> beanType, EbeanServer server, ExpressionFactory expressionFactory, DeployNamedQuery namedQuery) throws PersistenceException {
        this.beanType = beanType;
        this.server = server;
        this.expressionFactory = expressionFactory;
        this.detail = new OrmQueryDetail();
        if (namedQuery == null) {
            this.name = "";
        } else {
            this.name = namedQuery.getName();
            this.sqlSelect = namedQuery.isSqlSelect();
            if (this.sqlSelect) {
                DRawSqlSelect sqlSelect = namedQuery.getSqlSelect();
                this.additionalWhere = sqlSelect.getWhereClause();
                this.additionalHaving = sqlSelect.getHavingClause();
            } else if (namedQuery.isRawSql()) {
                this.rawSql = namedQuery.getRawSql();
            } else {
                this.setQuery(namedQuery.getQuery());
            }
        }
    }

    @Override
    public void setBeanDescriptor(BeanDescriptor<?> beanDescriptor) {
        this.beanDescriptor = beanDescriptor;
    }

    @Override
    public boolean selectAllForLazyLoadProperty() {
        if (this.lazyLoadProperty != null && !this.detail.containsProperty(this.lazyLoadProperty)) {
            this.detail.select("*");
            return true;
        }
        return false;
    }

    @Override
    public RawSql getRawSql() {
        return this.rawSql;
    }

    @Override
    public DefaultOrmQuery<T> setRawSql(RawSql rawSql) {
        this.rawSql = rawSql;
        return this;
    }

    @Override
    public String getLazyLoadProperty() {
        return this.lazyLoadProperty;
    }

    @Override
    public void setLazyLoadProperty(String lazyLoadProperty) {
        this.lazyLoadProperty = lazyLoadProperty;
    }

    @Override
    public String getLazyLoadManyPath() {
        return this.lazyLoadManyPath;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    @Override
    public void setParentState(int parentState) {
        if (parentState == 3) {
            this.setSharedInstance();
        } else if (parentState == 2) {
            this.setReadOnly(true);
        }
    }

    public MetaAutoFetchStatistic getMetaAutoFetchStatistic() {
        if (this.parentNode != null && this.server != null) {
            ObjectGraphOrigin origin = this.parentNode.getOriginQueryPoint();
            return this.server.find(MetaAutoFetchStatistic.class, origin.getKey());
        }
        return null;
    }

    @Override
    public boolean initManyWhereJoins() {
        this.manyWhereJoins = new ManyWhereJoins();
        if (this.whereExpressions != null) {
            this.whereExpressions.containsMany(this.beanDescriptor, this.manyWhereJoins);
        }
        return !this.manyWhereJoins.isEmpty();
    }

    @Override
    public ManyWhereJoins getManyWhereJoins() {
        return this.manyWhereJoins;
    }

    @Override
    public List<OrmQueryProperties> removeQueryJoins() {
        List<OrmQueryProperties> queryJoins = this.detail.removeSecondaryQueries();
        if (queryJoins != null && this.orderBy != null) {
            for (int i = 0; i < queryJoins.size(); ++i) {
                OrmQueryProperties joinPath = queryJoins.get(i);
                List<OrderBy.Property> properties = this.orderBy.getProperties();
                Iterator<OrderBy.Property> it = properties.iterator();
                while (it.hasNext()) {
                    OrderBy.Property property = it.next();
                    if (!property.getProperty().startsWith(joinPath.getPath())) continue;
                    it.remove();
                    joinPath.addSecJoinOrderProperty(property);
                }
            }
        }
        return queryJoins;
    }

    @Override
    public List<OrmQueryProperties> removeLazyJoins() {
        return this.detail.removeSecondaryLazyQueries();
    }

    @Override
    public void setLazyLoadManyPath(String lazyLoadManyPath) {
        this.lazyLoadManyPath = lazyLoadManyPath;
    }

    @Override
    public void convertManyFetchJoinsToQueryJoins(boolean allowOne, int queryBatch) {
        this.detail.convertManyFetchJoinsToQueryJoins(this.beanDescriptor, this.lazyLoadManyPath, allowOne, queryBatch);
    }

    @Override
    public void setSelectId() {
        this.detail.clear();
        this.select(this.beanDescriptor.getIdBinder().getIdProperty());
    }

    @Override
    public DefaultOrmQuery<T> copy() {
        DefaultOrmQuery<T> copy = new DefaultOrmQuery<T>(this.beanType, this.server, this.expressionFactory, (String)null);
        copy.name = this.name;
        copy.includeTableJoin = this.includeTableJoin;
        copy.autoFetchManager = this.autoFetchManager;
        copy.query = this.query;
        copy.additionalWhere = this.additionalWhere;
        copy.additionalHaving = this.additionalHaving;
        copy.distinct = this.distinct;
        copy.backgroundFetchAfter = this.backgroundFetchAfter;
        copy.timeout = this.timeout;
        copy.mapKey = this.mapKey;
        copy.id = this.id;
        copy.vanillaMode = this.vanillaMode;
        copy.loadBeanCache = this.loadBeanCache;
        copy.useBeanCache = this.useBeanCache;
        copy.useQueryCache = this.useQueryCache;
        copy.readOnly = this.readOnly;
        copy.sqlSelect = this.sqlSelect;
        if (this.detail != null) {
            copy.detail = this.detail.copy();
        }
        copy.firstRow = this.firstRow;
        copy.maxRows = this.maxRows;
        copy.rawWhereClause = this.rawWhereClause;
        if (this.orderBy != null) {
            copy.orderBy = this.orderBy.copy();
        }
        if (this.bindParams != null) {
            copy.bindParams = this.bindParams.copy();
        }
        if (this.whereExpressions != null) {
            copy.whereExpressions = this.whereExpressions.copy(copy);
        }
        if (this.havingExpressions != null) {
            copy.havingExpressions = this.havingExpressions.copy(copy);
        }
        copy.usageProfiling = this.usageProfiling;
        copy.autoFetch = this.autoFetch;
        copy.parentNode = this.parentNode;
        return copy;
    }

    @Override
    public Query.Type getType() {
        return this.type;
    }

    @Override
    public void setType(Query.Type type) {
        this.type = type;
    }

    @Override
    public String getLoadDescription() {
        return this.loadDescription;
    }

    @Override
    public String getLoadMode() {
        return this.loadMode;
    }

    @Override
    public void setLoadDescription(String loadMode, String loadDescription) {
        this.loadMode = loadMode;
        this.loadDescription = loadDescription;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Override
    public boolean isDetailEmpty() {
        return this.detail.isEmpty();
    }

    @Override
    public boolean isAutofetchTuned() {
        return this.autoFetchTuned;
    }

    @Override
    public void setAutoFetchTuned(boolean autoFetchTuned) {
        this.autoFetchTuned = autoFetchTuned;
    }

    @Override
    public Boolean isAutofetch() {
        return this.sqlSelect ? Boolean.FALSE : this.autoFetch;
    }

    public DefaultOrmQuery<T> setAutoFetch(boolean autoFetch) {
        return this.setAutofetch(autoFetch);
    }

    @Override
    public DefaultOrmQuery<T> setAutofetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
        return this;
    }

    @Override
    public AutoFetchManager getAutoFetchManager() {
        return this.autoFetchManager;
    }

    @Override
    public void setAutoFetchManager(AutoFetchManager autoFetchManager) {
        this.autoFetchManager = autoFetchManager;
    }

    @Override
    public void deriveSharedInstance() {
        if (!this.sharedInstance && (Boolean.TRUE.equals(this.useQueryCache) || Boolean.TRUE.equals(this.readOnly) && (Boolean.TRUE.equals(this.useBeanCache) || Boolean.TRUE.equals(this.loadBeanCache)))) {
            this.sharedInstance = true;
        }
    }

    @Override
    public boolean isSharedInstance() {
        return this.sharedInstance;
    }

    @Override
    public void setSharedInstance() {
        this.sharedInstance = true;
    }

    @Override
    public SpiQuery.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(SpiQuery.Mode mode) {
        this.mode = mode;
    }

    @Override
    public boolean isUsageProfiling() {
        return this.usageProfiling;
    }

    @Override
    public void setUsageProfiling(boolean usageProfiling) {
        this.usageProfiling = usageProfiling;
    }

    @Override
    public void setParentNode(ObjectGraphNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public ObjectGraphNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public ObjectGraphNode setOrigin(CallStack callStack) {
        ObjectGraphOrigin o = new ObjectGraphOrigin(this.calculateOriginQueryHash(), callStack, this.beanType.getName());
        this.parentNode = new ObjectGraphNode(o, null);
        return this.parentNode;
    }

    private int calculateOriginQueryHash() {
        int hc = this.beanType.getName().hashCode();
        hc = hc * 31 + (this.type == null ? 0 : this.type.ordinal());
        return hc;
    }

    private int calculateHash(BeanQueryRequest<?> request) {
        int hc = this.beanType.getName().hashCode();
        hc = hc * 31 + (this.type == null ? 0 : this.type.ordinal());
        hc = hc * 31 + (this.rawSql == null ? 0 : this.rawSql.queryHash());
        hc = hc * 31 + (this.autoFetchTuned ? 31 : 0);
        hc = hc * 31 + (this.distinct ? 31 : 0);
        hc = hc * 31 + (this.query == null ? 0 : this.query.hashCode());
        hc = hc * 31 + this.detail.queryPlanHash(request);
        hc = hc * 31 + (this.firstRow == 0 ? 0 : this.firstRow);
        hc = hc * 31 + (this.maxRows == 0 ? 0 : this.maxRows);
        hc = hc * 31 + (this.orderBy == null ? 0 : this.orderBy.hash());
        hc = hc * 31 + (this.rawWhereClause == null ? 0 : this.rawWhereClause.hashCode());
        hc = hc * 31 + (this.additionalWhere == null ? 0 : this.additionalWhere.hashCode());
        hc = hc * 31 + (this.additionalHaving == null ? 0 : this.additionalHaving.hashCode());
        hc = hc * 31 + (this.mapKey == null ? 0 : this.mapKey.hashCode());
        hc = hc * 31 + (this.id == null ? 0 : 1);
        if (this.bindParams != null) {
            hc = hc * 31 + this.bindParams.getQueryPlanHash();
        }
        if (request == null) {
            hc = hc * 31 + (this.whereExpressions == null ? 0 : this.whereExpressions.queryAutoFetchHash());
            hc = hc * 31 + (this.havingExpressions == null ? 0 : this.havingExpressions.queryAutoFetchHash());
        } else {
            hc = hc * 31 + (this.whereExpressions == null ? 0 : this.whereExpressions.queryPlanHash(request));
            hc = hc * 31 + (this.havingExpressions == null ? 0 : this.havingExpressions.queryPlanHash(request));
        }
        return hc;
    }

    @Override
    public int queryAutofetchHash() {
        return this.calculateHash(null);
    }

    @Override
    public int queryPlanHash(BeanQueryRequest<?> request) {
        this.queryPlanHash = this.calculateHash(request);
        return this.queryPlanHash;
    }

    @Override
    public int queryBindHash() {
        int hc = this.id == null ? 0 : this.id.hashCode();
        hc = hc * 31 + (this.whereExpressions == null ? 0 : this.whereExpressions.queryBindHash());
        hc = hc * 31 + (this.havingExpressions == null ? 0 : this.havingExpressions.queryBindHash());
        hc = hc * 31 + (this.bindParams == null ? 0 : this.bindParams.queryBindHash());
        hc = hc * 31 + (this.contextAdditions == null ? 0 : this.contextAdditions.hashCode());
        return hc;
    }

    @Override
    public int queryHash() {
        int hc = this.queryPlanHash;
        hc = hc * 31 + this.queryBindHash();
        return hc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSqlSelect() {
        return this.sqlSelect;
    }

    @Override
    public String getAdditionalWhere() {
        return this.additionalWhere;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getAdditionalHaving() {
        return this.additionalHaving;
    }

    @Override
    public boolean hasMaxRowsOrFirstRow() {
        return this.maxRows > 0 || this.firstRow > 0;
    }

    @Override
    public boolean isVanillaMode(boolean defaultVanillaMode) {
        if (this.vanillaMode != null) {
            return this.vanillaMode;
        }
        return defaultVanillaMode;
    }

    @Override
    public DefaultOrmQuery<T> setVanillaMode(boolean vanillaMode) {
        this.vanillaMode = vanillaMode;
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public DefaultOrmQuery<T> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public Boolean isUseBeanCache() {
        return this.useBeanCache;
    }

    @Override
    public boolean isUseQueryCache() {
        return Boolean.TRUE.equals(this.useQueryCache);
    }

    @Override
    public DefaultOrmQuery<T> setUseCache(boolean useBeanCache) {
        this.useBeanCache = useBeanCache;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setUseQueryCache(boolean useQueryCache) {
        this.useQueryCache = useQueryCache;
        return this;
    }

    @Override
    public boolean isLoadBeanCache() {
        return this.loadBeanCache;
    }

    @Override
    public DefaultOrmQuery<T> setLoadBeanCache(boolean loadBeanCache) {
        this.loadBeanCache = loadBeanCache;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setTimeout(int secs) {
        this.timeout = secs;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setQuery(String queryString) throws PersistenceException {
        this.query = queryString;
        OrmQueryDetailParser parser = new OrmQueryDetailParser(queryString);
        parser.parse();
        parser.assign(this);
        return this;
    }

    protected void setOrmQueryDetail(OrmQueryDetail detail) {
        this.detail = detail;
    }

    protected void setRawWhereClause(String rawWhereClause) {
        this.rawWhereClause = rawWhereClause;
    }

    public DefaultOrmQuery<T> setProperties(String columns) {
        return this.select(columns);
    }

    @Override
    public void setDefaultSelectClause() {
        this.detail.setDefaultSelectClause(this.beanDescriptor);
    }

    @Override
    public DefaultOrmQuery<T> select(String columns) {
        this.detail.select(columns);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> join(String property) {
        return this.join(property, null, null);
    }

    @Override
    public DefaultOrmQuery<T> join(String property, JoinConfig joinConfig) {
        return this.join(property, null, joinConfig);
    }

    @Override
    public DefaultOrmQuery<T> join(String property, String columns) {
        return this.join(property, columns, null);
    }

    @Override
    public DefaultOrmQuery<T> join(String property, String columns, JoinConfig joinConfig) {
        FetchConfig c;
        if (joinConfig == null) {
            c = null;
        } else {
            c = new FetchConfig();
            c.lazy(joinConfig.getLazyBatchSize());
            if (joinConfig.isQueryAll()) {
                c.query(joinConfig.getQueryBatchSize());
            } else {
                c.queryFirst(joinConfig.getQueryBatchSize());
            }
        }
        this.detail.addFetch(property, columns, c);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property) {
        return this.fetch(property, null, null);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, FetchConfig joinConfig) {
        return this.fetch(property, null, joinConfig);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, String columns) {
        return this.fetch(property, columns, null);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, String columns, FetchConfig config) {
        this.detail.addFetch(property, columns, config);
        return this;
    }

    @Override
    public List<Object> findIds() {
        return this.server.findIds(this, null);
    }

    @Override
    public int findRowCount() {
        return this.server.findRowCount(this, null);
    }

    @Override
    public List<T> findList() {
        return this.server.findList(this, null);
    }

    @Override
    public Set<T> findSet() {
        return this.server.findSet(this, null);
    }

    @Override
    public Map<?, T> findMap() {
        return this.server.findMap(this, null);
    }

    @Override
    public T findUnique() {
        return this.server.findUnique(this, null);
    }

    @Override
    public FutureIds<T> findFutureIds() {
        return this.server.findFutureIds(this, null);
    }

    @Override
    public FutureList<T> findFutureList() {
        return this.server.findFutureList(this, null);
    }

    @Override
    public FutureRowCount<T> findFutureRowCount() {
        return this.server.findFutureRowCount(this, null);
    }

    @Override
    public PagingList<T> findPagingList(int pageSize) {
        return this.server.findPagingList(this, null, pageSize);
    }

    @Override
    public DefaultOrmQuery<T> setParameter(int position, Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(position, value);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setParameter(String name, Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(name, value);
        return this;
    }

    @Override
    public String getOrderByStringFormat() {
        if (this.orderBy == null) {
            return null;
        }
        return this.orderBy.toStringFormat();
    }

    @Override
    public String getRawWhereClause() {
        return this.rawWhereClause;
    }

    @Override
    public OrderBy<T> orderBy() {
        return this.order();
    }

    @Override
    public OrderBy<T> order() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy(this, null);
        }
        return this.orderBy;
    }

    public DefaultOrmQuery<T> setOrderBy(String orderByClause) {
        return this.order(orderByClause);
    }

    @Override
    public DefaultOrmQuery<T> orderBy(String orderByClause) {
        return this.order(orderByClause);
    }

    @Override
    public DefaultOrmQuery<T> order(String orderByClause) {
        this.orderBy = orderByClause == null || orderByClause.trim().length() == 0 ? null : new OrderBy(this, orderByClause);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setOrderBy(OrderBy<T> orderBy) {
        return this.setOrder((OrderBy)orderBy);
    }

    @Override
    public DefaultOrmQuery<T> setOrder(OrderBy<T> orderBy) {
        this.orderBy = orderBy;
        if (orderBy != null) {
            orderBy.setQuery(this);
        }
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public DefaultOrmQuery<T> setDistinct(boolean isDistinct) {
        this.distinct = isDistinct;
        return this;
    }

    @Override
    public QueryListener<T> getListener() {
        return this.queryListener;
    }

    @Override
    public DefaultOrmQuery<T> setListener(QueryListener<T> queryListener) {
        this.queryListener = queryListener;
        return this;
    }

    @Override
    public Class<T> getBeanType() {
        return this.beanType;
    }

    @Override
    public void setDetail(OrmQueryDetail detail) {
        this.detail = detail;
    }

    @Override
    public boolean tuneFetchProperties(OrmQueryDetail tunedDetail) {
        return this.detail.tuneFetchProperties(tunedDetail);
    }

    @Override
    public OrmQueryDetail getDetail() {
        return this.detail;
    }

    @Override
    public final ArrayList<EntityBean> getContextAdditions() {
        return this.contextAdditions;
    }

    @Override
    public void contextAdd(EntityBean bean) {
        if (this.contextAdditions == null) {
            this.contextAdditions = new ArrayList();
        }
        this.contextAdditions.add(bean);
    }

    public String toString() {
        return "Query [" + this.whereExpressions + "]";
    }

    @Override
    public TableJoin getIncludeTableJoin() {
        return this.includeTableJoin;
    }

    @Override
    public void setIncludeTableJoin(TableJoin includeTableJoin) {
        this.includeTableJoin = includeTableJoin;
    }

    @Override
    public int getFirstRow() {
        return this.firstRow;
    }

    @Override
    public DefaultOrmQuery<T> setFirstRow(int firstRow) {
        this.firstRow = firstRow;
        return this;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public DefaultOrmQuery<T> setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public DefaultOrmQuery<T> setMapKey(String mapKey) {
        this.mapKey = mapKey;
        return this;
    }

    @Override
    public int getBackgroundFetchAfter() {
        return this.backgroundFetchAfter;
    }

    @Override
    public DefaultOrmQuery<T> setBackgroundFetchAfter(int backgroundFetchAfter) {
        this.backgroundFetchAfter = backgroundFetchAfter;
        return this;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public DefaultOrmQuery<T> setId(Object id) {
        this.id = id;
        return this;
    }

    @Override
    public BindParams getBindParams() {
        return this.bindParams;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public DefaultOrmQuery<T> addWhere(String addToWhereClause) {
        return this.where(addToWhereClause);
    }

    public DefaultOrmQuery<T> addWhere(Expression expression) {
        return this.where(expression);
    }

    public ExpressionList<T> addWhere() {
        return this.where();
    }

    @Override
    public DefaultOrmQuery<T> where(String addToWhereClause) {
        this.additionalWhere = this.additionalWhere == null ? addToWhereClause : this.additionalWhere + " " + addToWhereClause;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> where(Expression expression) {
        if (this.whereExpressions == null) {
            this.whereExpressions = new DefaultExpressionList(this);
        }
        this.whereExpressions.add(expression);
        return this;
    }

    @Override
    public ExpressionList<T> where() {
        if (this.whereExpressions == null) {
            this.whereExpressions = new DefaultExpressionList(this);
        }
        return this.whereExpressions;
    }

    @Override
    public ExpressionList<T> filterMany(String prop) {
        OrmQueryProperties chunk = this.detail.getChunk(prop, true);
        return chunk.filterMany(this);
    }

    @Override
    public void setFilterMany(String prop, ExpressionList<?> filterMany) {
        if (filterMany != null) {
            OrmQueryProperties chunk = this.detail.getChunk(prop, true);
            chunk.setFilterMany((SpiExpressionList)filterMany);
        }
    }

    public DefaultOrmQuery<T> addHaving(String addToHavingClause) {
        return this.having(addToHavingClause);
    }

    public DefaultOrmQuery<T> addHaving(Expression expression) {
        return this.having(expression);
    }

    public ExpressionList<T> addHaving() {
        return this.having();
    }

    @Override
    public DefaultOrmQuery<T> having(String addToHavingClause) {
        this.additionalHaving = this.additionalHaving == null ? addToHavingClause : this.additionalHaving + " " + addToHavingClause;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> having(Expression expression) {
        if (this.havingExpressions == null) {
            this.havingExpressions = new DefaultExpressionList(this);
        }
        this.havingExpressions.add(expression);
        return this;
    }

    @Override
    public ExpressionList<T> having() {
        if (this.havingExpressions == null) {
            this.havingExpressions = new DefaultExpressionList(this);
        }
        return this.havingExpressions;
    }

    @Override
    public SpiExpressionList<T> getHavingExpressions() {
        return this.havingExpressions;
    }

    @Override
    public SpiExpressionList<T> getWhereExpressions() {
        return this.whereExpressions;
    }

    @Override
    public boolean createOwnTransaction() {
        if (this.futureFetch) {
            return false;
        }
        return this.backgroundFetchAfter > 0 || this.queryListener != null;
    }

    @Override
    public String getGeneratedSql() {
        return this.generatedSql;
    }

    @Override
    public void setGeneratedSql(String generatedSql) {
        this.generatedSql = generatedSql;
    }

    @Override
    public Query<T> setBufferFetchSizeHint(int bufferFetchSizeHint) {
        this.bufferFetchSizeHint = bufferFetchSizeHint;
        return this;
    }

    @Override
    public int getBufferFetchSizeHint() {
        return this.bufferFetchSizeHint;
    }

    @Override
    public void setBeanCollectionTouched(BeanCollectionTouched notify) {
        this.beanCollectionTouched = notify;
    }

    @Override
    public BeanCollectionTouched getBeanCollectionTouched() {
        return this.beanCollectionTouched;
    }

    @Override
    public List<Object> getIdList() {
        return this.partialIds;
    }

    @Override
    public void setIdList(List<Object> partialIds) {
        this.partialIds = partialIds;
    }

    @Override
    public boolean isFutureFetch() {
        return this.futureFetch;
    }

    @Override
    public void setFutureFetch(boolean backgroundFetch) {
        this.futureFetch = backgroundFetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCancelableQuery(CancelableQuery cancelableQuery) {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            this.cancelableQuery = cancelableQuery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            this.cancelled = true;
            if (this.cancelableQuery != null) {
                this.cancelableQuery.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            return this.cancelled;
        }
    }
}

