/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebeaninternal.server.querydefn.DefaultOrmQuery;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import com.avaje.ebeaninternal.server.querydefn.SimpleTextParser;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmQueryDetailParser {
    private final OrmQueryDetail detail = new OrmQueryDetail();
    private int maxRows;
    private int firstRow;
    private String rawWhereClause;
    private String rawOrderBy;
    private final SimpleTextParser parser;

    public OrmQueryDetailParser(String oql) {
        this.parser = new SimpleTextParser(oql);
    }

    public void parse() throws PersistenceException {
        this.parser.nextWord();
        this.processInitial();
    }

    protected void assign(DefaultOrmQuery<?> query) {
        query.setOrmQueryDetail(this.detail);
        query.setFirstRow(this.firstRow);
        query.setMaxRows(this.maxRows);
        query.setRawWhereClause(this.rawWhereClause);
        query.order(this.rawOrderBy);
    }

    private void processInitial() {
        if (this.parser.isMatch("find")) {
            OrmQueryProperties props = this.readFindFetch();
            this.detail.setBase(props);
        } else {
            this.process();
        }
        while (!this.parser.isFinished()) {
            this.process();
        }
    }

    private boolean isFetch() {
        return this.parser.isMatch("fetch") || this.parser.isMatch("join");
    }

    private void process() {
        if (this.isFetch()) {
            OrmQueryProperties props = this.readFindFetch();
            this.detail.putFetchPath(props);
        } else if (this.parser.isMatch("where")) {
            this.readWhere();
        } else if (this.parser.isMatch("order", "by")) {
            this.readOrderBy();
        } else if (this.parser.isMatch("limit")) {
            this.readLimit();
        } else {
            throw new PersistenceException("Query expected 'fetch', 'where','order by' or 'limit' keyword but got [" + this.parser.getWord() + "] \r " + this.parser.getOql());
        }
    }

    private void readLimit() {
        try {
            String maxLimit = this.parser.nextWord();
            this.maxRows = Integer.parseInt(maxLimit);
            String offsetKeyword = this.parser.nextWord();
            if (offsetKeyword != null) {
                if (!this.parser.isMatch("offset")) {
                    throw new PersistenceException("expected offset keyword but got " + this.parser.getWord());
                }
                String firstRowLimit = this.parser.nextWord();
                this.firstRow = Integer.parseInt(firstRowLimit);
                this.parser.nextWord();
            }
        }
        catch (NumberFormatException e) {
            String msg = "Expected an integer for maxRows or firstRows in limit offset clause";
            throw new PersistenceException(msg, (Throwable)e);
        }
    }

    private void readOrderBy() {
        this.parser.nextWord();
        StringBuilder sb = new StringBuilder();
        while (this.parser.nextWord() != null && !this.parser.isMatch("limit")) {
            sb.append(" ").append(this.parser.getWord());
        }
        this.rawOrderBy = sb.toString().trim();
        if (!this.parser.isFinished()) {
            this.readLimit();
        }
    }

    private void readWhere() {
        String whereClause;
        int nextMode = 0;
        StringBuilder sb = new StringBuilder();
        while (this.parser.nextWord() != null) {
            if (this.parser.isMatch("order", "by")) {
                nextMode = 1;
                break;
            }
            if (this.parser.isMatch("limit")) {
                nextMode = 2;
                break;
            }
            sb.append(" ").append(this.parser.getWord());
        }
        if ((whereClause = sb.toString().trim()).length() > 0) {
            this.rawWhereClause = whereClause;
        }
        if (nextMode == 1) {
            this.readOrderBy();
        } else if (nextMode == 2) {
            this.readLimit();
        }
    }

    private OrmQueryProperties readFindFetch() {
        boolean readAlias = false;
        String props = null;
        String path = this.parser.nextWord();
        String token = null;
        while ((token = this.parser.nextWord()) != null) {
            if (!readAlias && this.parser.isMatch("as")) {
                this.parser.nextWord();
                readAlias = true;
                continue;
            }
            if ('(' == token.charAt(0)) {
                props = token;
                this.parser.nextWord();
                break;
            }
            if (this.isFindFetchEnd()) break;
            if (!readAlias) {
                readAlias = true;
                continue;
            }
            throw new PersistenceException("Expected (props) or new 'fetch' 'where' but got " + token);
        }
        if (props != null) {
            props = props.substring(1, props.length() - 1);
        }
        return new OrmQueryProperties(path, props);
    }

    private boolean isFindFetchEnd() {
        if (this.isFetch()) {
            return true;
        }
        if (this.parser.isMatch("where")) {
            return true;
        }
        return this.parser.isMatch("order", "by");
    }
}

