/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.api.TransactionEventBeans;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.transaction.RemoteBeanPersist;
import com.avaje.ebeaninternal.server.transaction.RemoteBeanPersistMap;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PostCommitProcessing
implements Runnable {
    private static final Logger logger = Logger.getLogger(PostCommitProcessing.class.getName());
    private final ClusterManager clusterManager;
    private final TransactionEvent event;
    private final String serverName;
    private final TransactionManager manager;

    public PostCommitProcessing(ClusterManager clusterManager, TransactionManager manager, TransactionEvent event) {
        this.clusterManager = clusterManager;
        this.manager = manager;
        this.serverName = manager.getServerName();
        this.event = event;
    }

    public void run() {
        ArrayList<PersistRequestBean<?>> requests;
        RemoteBeanPersistMap beanPersistMap = new RemoteBeanPersistMap();
        TransactionEventBeans eventBeans = this.event.getEventBeans();
        if (eventBeans != null && (requests = eventBeans.getRequests()) != null) {
            for (int i = 0; i < requests.size(); ++i) {
                requests.get(i).notifyLocalPersistListener(beanPersistMap);
            }
        }
        RemoteTransactionEvent remoteEvent = new RemoteTransactionEvent(this.serverName);
        for (RemoteBeanPersist beanPersist : beanPersistMap.values()) {
            remoteEvent.add(beanPersist);
        }
        TransactionEventTable eventTables = this.event.getEventTables();
        if (eventTables != null && !eventTables.isEmpty()) {
            for (TransactionEventTable.TableIUD tableIUD : eventTables.values()) {
                remoteEvent.add(tableIUD);
            }
        }
        if (!remoteEvent.isEmpty() && this.clusterManager.isClustering()) {
            if (this.manager.getClusterDebugLevel() > 0 || logger.isLoggable(Level.FINE)) {
                logger.info("Cluster Send: " + remoteEvent.toString());
            }
            this.clusterManager.broadcast(remoteEvent);
        }
    }
}

