/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cluster.BinaryMessageList;
import com.avaje.ebeaninternal.server.transaction.RemoteBeanPersist;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTransactionEvent
implements Serializable,
Runnable {
    private static final long serialVersionUID = 757920022500956949L;
    private ArrayList<RemoteBeanPersist> beanPersistList = new ArrayList();
    private ArrayList<TransactionEventTable.TableIUD> tableList = new ArrayList(4);
    private String serverName;
    private transient SpiEbeanServer server;

    public RemoteTransactionEvent(String serverName) {
        this.serverName = serverName;
    }

    public RemoteTransactionEvent(SpiEbeanServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        this.server.remoteTransactionEvent(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.beanPersistList);
        sb.append(this.tableList);
        return sb.toString();
    }

    public void writeBinaryMessage(BinaryMessageList msgList) throws IOException {
        int i;
        for (i = 0; i < this.tableList.size(); ++i) {
            this.tableList.get(i).writeBinaryMessage(msgList);
        }
        for (i = 0; i < this.beanPersistList.size(); ++i) {
            this.beanPersistList.get(i).writeBinaryMessage(msgList);
        }
    }

    public boolean isEmpty() {
        return this.beanPersistList.isEmpty() && this.tableList.isEmpty();
    }

    public void add(RemoteBeanPersist beanPersist) {
        this.beanPersistList.add(beanPersist);
    }

    public void add(TransactionEventTable.TableIUD tableIud) {
        this.tableList.add(tableIud);
    }

    public String getServerName() {
        return this.serverName;
    }

    public SpiEbeanServer getServer() {
        return this.server;
    }

    public void setServer(SpiEbeanServer server) {
        this.server = server;
    }

    public List<TransactionEventTable.TableIUD> getTableIUDList() {
        return this.tableList;
    }

    public List<RemoteBeanPersist> getBeanPersistList() {
        return this.beanPersistList;
    }
}

