/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.AdminLogging;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.transaction.TransactionLogBuffer;
import com.avaje.ebeaninternal.server.transaction.TransactionLogWriter;
import com.avaje.ebeaninternal.server.transaction.log.FileTransactionLogger;
import com.avaje.ebeaninternal.server.transaction.log.JuliTransactionLogger;
import java.io.File;
import java.util.logging.Logger;

public class TransactionLogManager {
    private static final Logger logger = Logger.getLogger(TransactionLogManager.class.getName());
    private final String serverName;
    private AdminLogging.LogLevel logLevel;
    private final TransactionLogWriter logWriter;

    public TransactionLogManager(ServerConfig serverConfig) {
        this.serverName = serverConfig.getName();
        this.logLevel = serverConfig.getLoggingLevel();
        boolean logToJavaLogger = serverConfig.isLoggingToJavaLogger();
        if (logToJavaLogger) {
            this.logWriter = new JuliTransactionLogger();
        } else {
            String dir = serverConfig.getLoggingDirectoryWithEval();
            if (dir == null) {
                dir = this.createDefaultLogsDirectory();
            }
            String m = "Transaction logs in: " + dir;
            logger.info(m);
            String middleName = GlobalProperties.get("ebean.logging.filename", "_txn_");
            int maxFileSize = GlobalProperties.getInt("ebean.logging.maxFileSize", 0x6400000);
            String logPrefix = this.serverName + middleName;
            String threadName = "EbeanTxnLogWriter-" + this.serverName;
            this.logWriter = new FileTransactionLogger(threadName, dir, logPrefix, maxFileSize);
        }
        if (this.logLevel == AdminLogging.LogLevel.NONE) {
            String m = "Transaction logging is OFF  ... ebean.log.level=0";
            logger.info(m);
        }
        this.logWriter.start();
    }

    public void shutdown() {
        this.logWriter.shutdown();
    }

    private String createDefaultLogsDirectory() {
        String dftlDir = "logs/trans";
        File f = new File(dftlDir);
        if (f.mkdirs()) {
            return dftlDir;
        }
        return "logs";
    }

    public void setLogLevel(AdminLogging.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public AdminLogging.LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void log(TransactionLogBuffer logBuffer) {
        this.logWriter.log(logBuffer);
    }
}

