/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.AdminLogging;
import com.avaje.ebean.TxIsolation;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.lib.thread.ThreadPool;
import com.avaje.ebeaninternal.server.lib.thread.ThreadPoolManager;
import com.avaje.ebeaninternal.server.transaction.ExternalJdbcTransaction;
import com.avaje.ebeaninternal.server.transaction.JdbcTransaction;
import com.avaje.ebeaninternal.server.transaction.PostCommitProcessing;
import com.avaje.ebeaninternal.server.transaction.RemoteBeanPersist;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import com.avaje.ebeaninternal.server.transaction.TransactionLogBuffer;
import com.avaje.ebeaninternal.server.transaction.TransactionLogManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;

public class TransactionManager {
    private static final Logger logger = Logger.getLogger(TransactionManager.class.getName());
    private final BeanDescriptorManager beanDescriptorManager;
    private final TransactionLogManager transLogger;
    private final String prefix;
    private final String externalTransPrefix;
    private final DataSource dataSource;
    private final OnQueryOnly onQueryOnly;
    private final boolean defaultBatchMode;
    private final ThreadPool threadPool;
    private final ClusterManager clusterManager;
    private final int debugLevel;
    private final String serverName;
    private AtomicLong transactionCounter = new AtomicLong(1000L);
    private int clusterDebugLevel;

    public TransactionManager(ClusterManager clusterManager, ServerConfig config, BeanDescriptorManager descMgr) {
        this.beanDescriptorManager = descMgr;
        this.clusterManager = clusterManager;
        this.serverName = config.getName();
        this.transLogger = new TransactionLogManager(config);
        this.threadPool = ThreadPoolManager.getThreadPool("EbeanTransactionManager");
        if (this.threadPool.getMinSize() == 0) {
            this.threadPool.setMinSize(1);
        }
        this.dataSource = config.getDataSource();
        if (config.isLoggingToJavaLogger()) {
            this.debugLevel = 0;
        } else {
            int debug;
            AdminLogging.LogLevelTxnCommit txDebugLevel = config.getLoggingLevelTxnCommit();
            int n = debug = txDebugLevel == null ? 0 : txDebugLevel.ordinal();
            if (debug < 1 && GlobalProperties.getBoolean("log.commit", false)) {
                debug = 1;
            }
            this.debugLevel = debug;
        }
        this.clusterDebugLevel = GlobalProperties.getInt("ebean.cluster.debuglevel", 0);
        this.defaultBatchMode = config.isPersistBatching();
        this.prefix = GlobalProperties.get("transaction.prefix", "");
        this.externalTransPrefix = GlobalProperties.get("transaction.prefix", "e");
        String value = GlobalProperties.get("transaction.onqueryonly", "ROLLBACK").toUpperCase().trim();
        this.onQueryOnly = this.getOnQueryOnly(value, this.dataSource);
    }

    public void shutdown() {
        this.transLogger.shutdown();
    }

    public AdminLogging.LogLevel getTransactionLogLevel() {
        return this.transLogger.getLogLevel();
    }

    public void setTransactionLogLevel(AdminLogging.LogLevel txLogLevel) {
        this.transLogger.setLogLevel(txLogLevel);
    }

    private OnQueryOnly getOnQueryOnly(String onQueryOnly, DataSource ds) {
        if (onQueryOnly.equals("COMMIT")) {
            return OnQueryOnly.COMMIT;
        }
        if (onQueryOnly.startsWith("CLOSE")) {
            if (!this.isReadCommitedIsolation(ds)) {
                String m = "transaction.queryonlyclose is true but the transaction Isolation Level is not READ_COMMITTED";
                throw new PersistenceException(m);
            }
            return OnQueryOnly.CLOSE_ON_READCOMMITTED;
        }
        return OnQueryOnly.ROLLBACK;
    }

    private boolean isReadCommitedIsolation(DataSource ds) {
        Connection c = null;
        try {
            c = ds.getConnection();
            int isolationLevel = c.getTransactionIsolation();
            boolean bl = isolationLevel == 2;
            return bl;
        }
        catch (SQLException ex) {
            String m = "Errored trying to determine the default Isolation Level";
            throw new PersistenceException(m, (Throwable)ex);
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "closing connection", ex);
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getClusterDebugLevel() {
        return this.clusterDebugLevel;
    }

    public void setClusterDebugLevel(int clusterDebugLevel) {
        this.clusterDebugLevel = clusterDebugLevel;
    }

    public OnQueryOnly getOnQueryOnly() {
        return this.onQueryOnly;
    }

    public TransactionLogManager getLogger() {
        return this.transLogger;
    }

    public void log(TransactionLogBuffer logBuffer) {
        this.transLogger.log(logBuffer);
    }

    public SpiTransaction wrapExternalConnection(Connection c) {
        return this.wrapExternalConnection(this.externalTransPrefix + c.hashCode(), c);
    }

    public SpiTransaction wrapExternalConnection(String id, Connection c) {
        ExternalJdbcTransaction t = new ExternalJdbcTransaction(id, true, c, this);
        if (this.defaultBatchMode) {
            t.setBatchMode(true);
        }
        return t;
    }

    public SpiTransaction createTransaction(boolean explicit, int isolationLevel) {
        try {
            long id = this.transactionCounter.incrementAndGet();
            Connection c = this.dataSource.getConnection();
            JdbcTransaction t = new JdbcTransaction(this.prefix + id, explicit, c, this);
            if (this.defaultBatchMode) {
                t.setBatchMode(true);
            }
            if (isolationLevel > -1) {
                c.setTransactionIsolation(isolationLevel);
            }
            if (this.debugLevel >= 3) {
                String msg = "Transaction [" + t.getId() + "] begin";
                if (isolationLevel > -1) {
                    TxIsolation txi = TxIsolation.fromLevel(isolationLevel);
                    msg = msg + " isolationLevel[" + (Object)((Object)txi) + "]";
                }
                logger.info(msg);
            }
            return t;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public SpiTransaction createQueryTransaction() {
        try {
            long id = this.transactionCounter.incrementAndGet();
            Connection c = this.dataSource.getConnection();
            JdbcTransaction t = new JdbcTransaction(this.prefix + id, false, c, this);
            if (this.defaultBatchMode) {
                t.setBatchMode(true);
            }
            if (this.debugLevel >= 3) {
                logger.info("Transaction [" + t.getId() + "] begin - queryOnly");
            }
            return t;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public void notifyOfRollback(SpiTransaction transaction, Throwable cause) {
        try {
            String msg = "Rollback";
            if (cause != null) {
                msg = msg + " error: " + this.formatThrowable(cause);
            }
            transaction.log(msg);
            if (this.debugLevel >= 1) {
                logger.info("Transaction [" + transaction.getId() + "] " + msg);
            }
        }
        catch (Exception ex) {
            String m = "Potentially Transaction Log incomplete due to error:";
            logger.log(Level.SEVERE, m, ex);
        }
    }

    public void notifyOfQueryOnly(boolean onCommit, SpiTransaction transaction, Throwable cause) {
        try {
            if (this.debugLevel >= 2) {
                String msg;
                if (onCommit) {
                    msg = "Commit queryOnly";
                } else {
                    msg = "Rollback queryOnly";
                    if (cause != null) {
                        msg = msg + " error: " + this.formatThrowable(cause);
                    }
                }
                transaction.log(msg);
                logger.info("Transaction [" + transaction.getId() + "] " + msg);
            }
            this.log(transaction.getLogBuffer());
        }
        catch (Exception ex) {
            String m = "Potentially Transaction Log incomplete due to error:";
            logger.log(Level.SEVERE, m, ex);
        }
    }

    private String formatThrowable(Throwable e) {
        if (e == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.formatThrowable(e, sb);
        return sb.toString();
    }

    private void formatThrowable(Throwable e, StringBuilder sb) {
        Throwable cause;
        sb.append(e.toString());
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            sb.append(" stack0: ");
            sb.append(stackTrace[0]);
        }
        if ((cause = e.getCause()) != null) {
            sb.append(" cause: ");
            this.formatThrowable(cause, sb);
        }
    }

    public void notifyOfCommit(SpiTransaction transaction) {
        try {
            this.log(transaction.getLogBuffer());
            TransactionEvent event = transaction.getEvent();
            TransactionEventTable tableEvents = event.notifyCache();
            this.processTableEvents(tableEvents);
            this.localCommitBackgroundProcess(event);
            if (this.debugLevel >= 1) {
                logger.info("Transaction [" + transaction.getId() + "] commit");
            }
        }
        catch (Exception ex) {
            String m = "Potentially Transaction Log incomplete due to error:";
            logger.log(Level.SEVERE, m, ex);
        }
    }

    public void externalModification(TransactionEventTable tableEvents) {
        this.processTableEvents(tableEvents);
        TransactionEvent event = new TransactionEvent();
        event.add(tableEvents);
        this.localCommitBackgroundProcess(event);
    }

    public void remoteTransactionEvent(RemoteTransactionEvent remoteEvent) {
        List<RemoteBeanPersist> beanPersistList;
        List<TransactionEventTable.TableIUD> tableIUDList;
        if (this.clusterDebugLevel > 0 || logger.isLoggable(Level.FINE)) {
            logger.info("Cluster Received: " + remoteEvent.toString());
        }
        if ((tableIUDList = remoteEvent.getTableIUDList()) != null) {
            for (int i = 0; i < tableIUDList.size(); ++i) {
                TransactionEventTable.TableIUD tableIUD = tableIUDList.get(i);
                this.beanDescriptorManager.cacheNotify(tableIUD);
            }
        }
        if ((beanPersistList = remoteEvent.getBeanPersistList()) != null) {
            for (int i = 0; i < beanPersistList.size(); ++i) {
                RemoteBeanPersist beanPersist = beanPersistList.get(i);
                beanPersist.notifyCacheAndListener();
            }
        }
    }

    private void localCommitBackgroundProcess(TransactionEvent event) {
        PostCommitProcessing postCommit = new PostCommitProcessing(this.clusterManager, this, event);
        this.threadPool.assign(postCommit, true);
    }

    private void processTableEvents(TransactionEventTable tableEvents) {
        if (tableEvents != null && !tableEvents.isEmpty()) {
            for (TransactionEventTable.TableIUD tableIUD : tableEvents.values()) {
                this.beanDescriptorManager.cacheNotify(tableIUD);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnQueryOnly {
        ROLLBACK,
        CLOSE_ON_READCOMMITTED,
        COMMIT;

    }
}

