/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebean.text.json.JsonValueAdapter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.EscapeJson;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalarTypeBaseVarchar<T>
extends ScalarTypeBase<T> {
    public ScalarTypeBaseVarchar(Class<T> type) {
        super(type, false, 12);
    }

    @Override
    public abstract T parse(String var1);

    public abstract T convertFromDbString(String var1);

    public abstract String convertToDbString(T var1);

    @Override
    public void bind(DataBind b, T value) throws SQLException {
        String s = this.convertToDbString(value);
        if (s == null) {
            b.setNull(12);
        } else {
            b.setString(s);
        }
    }

    @Override
    public T read(DataReader dataReader) throws SQLException {
        String s = dataReader.getString();
        if (s == null) {
            return null;
        }
        return this.convertFromDbString(s);
    }

    @Override
    public T toBeanType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.parse((String)value);
        }
        return (T)value;
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof String) {
            return this.parse((String)value);
        }
        return value;
    }

    @Override
    public T parseDateTime(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public T jsonFromString(String value, JsonValueAdapter ctx) {
        return this.parse(value);
    }

    public String toJsonString(Object value, JsonValueAdapter ctx) {
        String s = this.format(value);
        return EscapeJson.escapeQuote(s);
    }
}

