/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;

public class ScalarTypeBoolean {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBoolean
    extends ScalarTypeBase<Boolean> {
        private final String trueValue;
        private final String falseValue;

        public StringBoolean(String trueValue, String falseValue) {
            super(Boolean.class, false, 12);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public int getLength() {
            return Math.max(this.trueValue.length(), this.falseValue.length());
        }

        @Override
        public void bind(DataBind b, Boolean value) throws SQLException {
            if (value == null) {
                b.setNull(12);
            } else {
                b.setString(this.toString(value));
            }
        }

        @Override
        public Boolean read(DataReader dataReader) throws SQLException {
            String string = dataReader.getString();
            if (string == null) {
                return null;
            }
            if (string.equals(this.trueValue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Object toJdbcType(Object value) {
            return this.toString(value);
        }

        public String toString(Object value) {
            if (value == null) {
                return null;
            }
            Boolean b = (Boolean)value;
            if (b.booleanValue()) {
                return this.trueValue;
            }
            return this.falseValue;
        }

        @Override
        public Boolean toBeanType(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (this.trueValue.equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public String formatValue(Boolean t) {
            return t.toString();
        }

        @Override
        public Boolean parse(String value) {
            return Boolean.valueOf(value);
        }

        @Override
        public Boolean parseDateTime(long systemTimeMillis) {
            throw new TextException("Not Supported");
        }

        @Override
        public boolean isDateTimeCapable() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntBoolean
    extends ScalarTypeBase<Boolean> {
        private final Integer trueValue;
        private final Integer falseValue;

        public IntBoolean(Integer trueValue, Integer falseValue) {
            super(Boolean.class, false, 4);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public void bind(DataBind b, Boolean value) throws SQLException {
            if (value == null) {
                b.setNull(4);
            } else {
                b.setInt(this.toInteger(value));
            }
        }

        @Override
        public Boolean read(DataReader dataReader) throws SQLException {
            Integer i = dataReader.getInt();
            if (i == null) {
                return null;
            }
            if (i.equals(this.trueValue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Object toJdbcType(Object value) {
            return this.toInteger(value);
        }

        public Integer toInteger(Object value) {
            if (value == null) {
                return null;
            }
            Boolean b = (Boolean)value;
            if (b.booleanValue()) {
                return this.trueValue;
            }
            return this.falseValue;
        }

        @Override
        public Boolean toBeanType(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (this.trueValue.equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public String formatValue(Boolean t) {
            return t.toString();
        }

        @Override
        public Boolean parse(String value) {
            return Boolean.valueOf(value);
        }

        @Override
        public Boolean parseDateTime(long systemTimeMillis) {
            throw new TextException("Not Supported");
        }

        @Override
        public boolean isDateTimeCapable() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BitBoolean
    extends ScalarTypeBase<Boolean> {
        public BitBoolean() {
            super(Boolean.class, true, -7);
        }

        @Override
        public Boolean toBeanType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        @Override
        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        @Override
        public String formatValue(Boolean t) {
            return t.toString();
        }

        @Override
        public Boolean parse(String value) {
            return Boolean.valueOf(value);
        }

        @Override
        public Boolean parseDateTime(long systemTimeMillis) {
            throw new TextException("Not Supported");
        }

        @Override
        public boolean isDateTimeCapable() {
            return false;
        }

        @Override
        public void bind(DataBind b, Boolean value) throws SQLException {
            if (value == null) {
                b.setNull(-7);
            } else {
                b.setBoolean(value);
            }
        }

        @Override
        public Boolean read(DataReader dataReader) throws SQLException {
            return dataReader.getBoolean();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Native
    extends ScalarTypeBase<Boolean> {
        public Native() {
            super(Boolean.class, true, 16);
        }

        @Override
        public Boolean toBeanType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        @Override
        public Object toJdbcType(Object value) {
            return BasicTypeConverter.convert(value, this.jdbcType);
        }

        @Override
        public String formatValue(Boolean t) {
            return t.toString();
        }

        @Override
        public Boolean parse(String value) {
            return Boolean.valueOf(value);
        }

        @Override
        public Boolean parseDateTime(long systemTimeMillis) {
            throw new TextException("Not Supported");
        }

        @Override
        public boolean isDateTimeCapable() {
            return false;
        }

        @Override
        public void bind(DataBind b, Boolean value) throws SQLException {
            if (value == null) {
                b.setNull(16);
            } else {
                b.setBoolean(value);
            }
        }

        @Override
        public Boolean read(DataReader dataReader) throws SQLException {
            return dataReader.getBoolean();
        }
    }
}

