/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.JsonValueAdapter;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.Date;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeDate
extends ScalarTypeBase<Date> {
    public ScalarTypeDate() {
        super(Date.class, true, 91);
    }

    @Override
    public void bind(DataBind b, Date value) throws SQLException {
        if (value == null) {
            b.setNull(91);
        } else {
            b.setDate(value);
        }
    }

    @Override
    public Date read(DataReader dataReader) throws SQLException {
        return dataReader.getDate();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toDate(value);
    }

    @Override
    public Date toBeanType(Object value) {
        return BasicTypeConverter.toDate(value);
    }

    @Override
    public String formatValue(Date t) {
        return t.toString();
    }

    @Override
    public Date parse(String value) {
        return Date.valueOf(value);
    }

    @Override
    public Date parseDateTime(long systemTimeMillis) {
        return new Date(systemTimeMillis);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public String jsonToString(Date value, JsonValueAdapter ctx) {
        return ctx.jsonFromDate(value);
    }

    @Override
    public Date jsonFromString(String value, JsonValueAdapter ctx) {
        return ctx.jsonToDate(value);
    }
}

