/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.JsonValueAdapter;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;
import java.util.Date;
import org.joda.time.DateMidnight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeJodaDateMidnight
extends ScalarTypeBase<DateMidnight> {
    public ScalarTypeJodaDateMidnight() {
        super(DateMidnight.class, false, 91);
    }

    @Override
    public void bind(DataBind b, DateMidnight value) throws SQLException {
        if (value == null) {
            b.setNull(91);
        } else {
            b.setDate(new java.sql.Date(value.getMillis()));
        }
    }

    @Override
    public DateMidnight read(DataReader dataReader) throws SQLException {
        java.sql.Date date = dataReader.getDate();
        if (date == null) {
            return null;
        }
        return new DateMidnight(date.getTime());
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof DateMidnight) {
            return new java.sql.Date(((DateMidnight)value).getMillis());
        }
        return BasicTypeConverter.toDate(value);
    }

    @Override
    public DateMidnight toBeanType(Object value) {
        if (value instanceof Date) {
            return new DateMidnight(((Date)value).getTime());
        }
        return (DateMidnight)value;
    }

    @Override
    public String formatValue(DateMidnight v) {
        java.sql.Date sqlDate = new java.sql.Date(v.getMillis());
        return sqlDate.toString();
    }

    @Override
    public DateMidnight parse(String value) {
        java.sql.Date sqlDate = java.sql.Date.valueOf(value);
        return new DateMidnight(sqlDate.getTime());
    }

    @Override
    public DateMidnight parseDateTime(long systemTimeMillis) {
        return new DateMidnight(systemTimeMillis);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public String jsonToString(DateMidnight value, JsonValueAdapter ctx) {
        java.sql.Date d = (java.sql.Date)this.toJdbcType(value);
        return ctx.jsonFromDate(d);
    }
}

