/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.JsonValueAdapter;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeTimestamp
extends ScalarTypeBase<Timestamp> {
    public ScalarTypeTimestamp() {
        super(Timestamp.class, true, 93);
    }

    @Override
    public void bind(DataBind b, Timestamp value) throws SQLException {
        if (value == null) {
            b.setNull(93);
        } else {
            b.setTimestamp(value);
        }
    }

    @Override
    public Timestamp read(DataReader dataReader) throws SQLException {
        return dataReader.getTimestamp();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toTimestamp(value);
    }

    @Override
    public Timestamp toBeanType(Object value) {
        return BasicTypeConverter.toTimestamp(value);
    }

    @Override
    public String formatValue(Timestamp v) {
        return v.toString();
    }

    @Override
    public Timestamp parse(String value) {
        try {
            return Timestamp.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            String m = "Error paring [" + value + "]";
            throw new RuntimeException(m, e);
        }
    }

    @Override
    public Timestamp parseDateTime(long systemTimeMillis) {
        return new Timestamp(systemTimeMillis);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public String jsonToString(Timestamp value, JsonValueAdapter ctx) {
        return ctx.jsonFromTimestamp(value);
    }

    @Override
    public Timestamp jsonFromString(String value, JsonValueAdapter ctx) {
        return ctx.jsonToTimestamp(value);
    }
}

