/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebean.text.json.JsonValueAdapter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.EscapeJson;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeURI
extends ScalarTypeBase<URI> {
    public ScalarTypeURI() {
        super(URI.class, false, 12);
    }

    @Override
    public void bind(DataBind b, URI value) throws SQLException {
        if (value == null) {
            b.setNull(12);
        } else {
            b.setString(value.toString());
        }
    }

    @Override
    public URI read(DataReader dataReader) throws SQLException {
        String str = dataReader.getString();
        if (str == null) {
            return null;
        }
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Error with URI [" + str + "] " + e);
        }
    }

    @Override
    public URI toBeanType(Object value) {
        if (value instanceof String) {
            try {
                return new URI((String)value);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Error with URI [" + value + "] " + e);
            }
        }
        return (URI)value;
    }

    @Override
    public Object toJdbcType(Object value) {
        return value.toString();
    }

    @Override
    public String formatValue(URI v) {
        return v.toString();
    }

    @Override
    public URI parse(String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new TextException("Error with URI [" + value + "] ", e);
        }
    }

    @Override
    public URI parseDateTime(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public URI jsonFromString(String value, JsonValueAdapter ctx) {
        return this.parse(value);
    }

    @Override
    public String jsonToString(URI value, JsonValueAdapter ctx) {
        String s = this.format(value);
        return EscapeJson.escapeQuote(s);
    }
}

