/*
 * Decompiled with CFR 0.152.
 */
package play.modules.ebean;

import com.avaje.ebean.enhance.agent.ClassBytesReader;
import com.avaje.ebean.enhance.agent.InputStreamTransform;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.exceptions.UnexpectedException;
import play.modules.ebean.PlayAwareTransformer;

public class EbeanEnhancer
extends Enhancer {
    static ClassFileTransformer transformer = new PlayAwareTransformer(new PlayClassBytesReader(), "transientInternalFields=true;debug=0");

    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        CtClass ctClass;
        byte[] buffer = transformer.transform((ClassLoader)Play.classloader, applicationClass.name, null, null, applicationClass.enhancedByteCode);
        if (buffer != null) {
            applicationClass.enhancedByteCode = buffer;
        }
        if (!(ctClass = this.makeClass(applicationClass)).subtypeOf(this.classPool.get("play.modules.ebean.EbeanSupport"))) {
            return;
        }
        if (!this.hasAnnotation(ctClass, "javax.persistence.Entity")) {
            return;
        }
        String entityName = ctClass.getName();
        try {
            boolean hasDefaultConstructor = false;
            for (CtConstructor constructor : ctClass.getConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                hasDefaultConstructor = true;
                break;
            }
            if (!hasDefaultConstructor && !ctClass.isInterface()) {
                CtConstructor defaultConstructor = CtNewConstructor.make((String)("private " + ctClass.getSimpleName() + "() {}"), (CtClass)ctClass);
                ctClass.addConstructor(defaultConstructor);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Error in EbeanEnhancer", (Object[])new Object[0]);
            throw new UnexpectedException("Error in EbeanEnhancer", (Throwable)e);
        }
        CtMethod create = CtMethod.make((String)("public static play.modules.ebean.EbeanSupport create(String name, play.mvc.Scope.Params params) { return create(" + entityName + ".class,name, params); }"), (CtClass)ctClass);
        ctClass.addMethod(create);
        CtMethod deleteAll = CtMethod.make((String)("public static int deleteAll() { return  ebean().createUpdate(" + entityName + ".class, \"delete from " + ctClass.getSimpleName() + "\").execute(); }"), (CtClass)ctClass);
        ctClass.addMethod(deleteAll);
        CtMethod findAll = CtMethod.make((String)("public static java.util.List findAll() { return ebean().find(" + entityName + ".class).findList(); }"), (CtClass)ctClass);
        ctClass.addMethod(findAll);
        CtMethod findById = CtMethod.make((String)("public static play.modules.ebean.EbeanSupport findById(Object id) { return (" + entityName + ") ebean().find(" + entityName + ".class, id); }"), (CtClass)ctClass);
        ctClass.addMethod(findById);
        CtMethod fundUnique = CtMethod.make((String)("public static play.modules.ebean.EbeanSupport findUnique(String property, Object value, Object[] moreParams) { return findUnique(" + entityName + ".class, property,value, moreParams); }"), (CtClass)ctClass);
        ctClass.addMethod(fundUnique);
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.defrost();
    }

    static class PlayClassBytesReader
    implements ClassBytesReader {
        PlayClassBytesReader() {
        }

        public byte[] getClassBytes(String className, ClassLoader classLoader) {
            ApplicationClasses.ApplicationClass ac = Play.classes.getApplicationClass(className.replace("/", "."));
            return ac != null ? ac.enhancedByteCode : this.getBytesFromClassPath(className);
        }

        private byte[] getBytesFromClassPath(String className) {
            String resource = className + ".class";
            byte[] classBytes = null;
            InputStream is = Play.classloader.getResourceAsStream(resource);
            try {
                classBytes = InputStreamTransform.readBytes((InputStream)is);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException reading bytes for " + className, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error closing InputStream for " + className, e);
                    }
                }
            }
            return classBytes;
        }
    }
}

