/*
 * Decompiled with CFR 0.152.
 */
package play.modules.ebean;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.Query;
import com.avaje.ebean.Update;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.event.BeanPersistController;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.sql.DataSource;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.data.binding.Binder;
import play.db.DB;
import play.db.Model;
import play.db.jpa.JPAPlugin;
import play.exceptions.UnexpectedException;
import play.modules.ebean.EbeanContext;
import play.modules.ebean.EbeanDataSourceWrapper;
import play.modules.ebean.EbeanEnhancer;
import play.modules.ebean.EbeanModelAdapter;
import play.modules.ebean.EbeanSupport;
import play.mvc.Http;

public class EbeanPlugin
extends PlayPlugin {
    public static EbeanServer defaultServer;
    public static Map<String, EbeanServer> SERVERS;

    public static EbeanServer createServer(String name, DataSource dataSource) {
        EbeanServer result = null;
        ServerConfig cfg = new ServerConfig();
        cfg.loadFromProperties();
        cfg.setName(name);
        cfg.setClasses(Play.classloader.getAllClasses());
        cfg.setDataSource((DataSource)new EbeanDataSourceWrapper(dataSource));
        cfg.setRegister("default".equals(name));
        cfg.setDefaultServer("default".equals(name));
        cfg.add((BeanPersistController)new EbeanModelAdapter());
        try {
            result = EbeanServerFactory.create((ServerConfig)cfg);
        }
        catch (Throwable t) {
            Logger.error((String)"Failed to create ebean server (%s)", (Object[])new Object[]{t.getMessage()});
        }
        return result;
    }

    public void onLoad() {
        for (PlayPlugin plugin : Play.plugins) {
            if (!(plugin instanceof JPAPlugin)) continue;
            Logger.debug((String)"EBEAN: Removing JPAPlugin in order to replace JPA implementation", (Object[])new Object[0]);
            Play.plugins.remove(plugin);
            break;
        }
    }

    public void onApplicationStart() {
        if (DB.datasource != null) {
            Logger.debug((String)"EBEAN: Creating default server", (Object[])new Object[0]);
            defaultServer = EbeanPlugin.createServer("default", DB.datasource);
        }
    }

    public void beforeInvocation() {
        String firstKey;
        EbeanServer server = defaultServer;
        Map ds = (Map)Http.Request.current().args.get("dataSources");
        if (ds != null && (firstKey = (String)ds.keySet().iterator().next()) != null && (server = SERVERS.get(firstKey)) == null) {
            server = EbeanPlugin.createServer(firstKey, (DataSource)ds.get(firstKey));
            SERVERS.put(firstKey, server);
        }
        EbeanContext.set(server, new Object[0]);
    }

    public void afterInvocation() {
        EbeanServer ebean = EbeanContext.server();
        if (ebean != null && ebean.currentTransaction() != null) {
            ebean.commitTransaction();
        }
    }

    public void invocationFinally() {
        EbeanServer ebean = EbeanContext.server();
        if (ebean != null) {
            ebean.endTransaction();
        }
        EbeanContext.set(null, new Object[0]);
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        try {
            ((EbeanEnhancer)((Object)EbeanEnhancer.class.newInstance())).enhanceThisClass(applicationClass);
        }
        catch (Throwable t) {
            Logger.error((Throwable)t, (String)"EbeanPlugin enhancement error", (Object[])new Object[0]);
        }
    }

    public Model.Factory modelFactory(Class<? extends Model> modelClass) {
        if (EbeanSupport.class.isAssignableFrom(modelClass) && modelClass.isAnnotationPresent(Entity.class)) {
            return new EbeanModelLoader(modelClass);
        }
        return null;
    }

    public Object bind(String name, Class clazz, Type type, Annotation[] annotations, Map<String, String[]> params) {
        if (EbeanSupport.class.isAssignableFrom(clazz)) {
            String keyName = Model.Manager.factoryFor((Class)clazz).keyName();
            String idKey = name + "." + keyName;
            if (params.containsKey(idKey) && params.get(idKey).length > 0 && params.get(idKey)[0] != null && params.get(idKey)[0].trim().length() > 0) {
                Object o;
                String id = params.get(idKey)[0];
                try {
                    o = EbeanContext.server().find(clazz, Binder.directBind((String)name, (Annotation[])annotations, (String)id, (Class)Model.Manager.factoryFor((Class)clazz).keyType()));
                }
                catch (Exception e) {
                    throw new UnexpectedException((Throwable)e);
                }
                return EbeanSupport.edit(o, name, params, annotations);
            }
            return EbeanSupport.create(clazz, name, params, annotations);
        }
        return super.bind(name, clazz, type, annotations, params);
    }

    public Object bind(String name, Object o, Map<String, String[]> params) {
        if (o instanceof EbeanSupport) {
            return EbeanSupport.edit(o, name, params, null);
        }
        return null;
    }

    static {
        SERVERS = new HashMap<String, EbeanServer>();
    }

    public static class EbeanModelLoader
    implements Model.Factory {
        private Class<? extends EbeanSupport> modelClass;

        public EbeanModelLoader(Class<EbeanSupport> modelClass) {
            this.modelClass = modelClass;
        }

        public String keyName() {
            return this.keyField().getName();
        }

        public Class<?> keyType() {
            return this.keyField().getType();
        }

        public Object keyValue(Model m) {
            try {
                return this.keyField().get(m);
            }
            catch (Exception ex) {
                throw new UnexpectedException((Throwable)ex);
            }
        }

        public Model findById(Object id) {
            if (id == null) {
                return null;
            }
            try {
                return (Model)EbeanContext.server().find(this.modelClass, Binder.directBind((String)id.toString(), this.keyType()));
            }
            catch (Exception e) {
                return null;
            }
        }

        public List<Model> fetch(int offset, int size, String orderBy, String order, List<String> searchFields, String keywords, String where) {
            String searchQuery;
            Query q = EbeanContext.server().createQuery(this.modelClass);
            String filter = null;
            if (where != null && !where.trim().equals("")) {
                filter = where.trim();
            }
            if (keywords != null && !keywords.equals("") && !(searchQuery = this.getSearchQuery(searchFields)).equals("")) {
                filter = (filter != null ? "(" + filter + ") and " : "") + "(" + searchQuery + ")";
            }
            if (filter != null) {
                q.where(filter);
                if (filter.indexOf(":keywords") != -1) {
                    q.setParameter("keywords", (Object)("%" + keywords.toLowerCase() + "%"));
                }
            }
            if (orderBy == null && order == null) {
                orderBy = "id";
                order = "ASC";
            }
            if (orderBy == null && order != null) {
                orderBy = "id";
            }
            if (order == null || !order.equals("ASC") && !order.equals("DESC")) {
                order = "ASC";
            }
            q.orderBy(orderBy + " " + order);
            q.setFirstRow(offset).setMaxRows(size);
            return q.findList();
        }

        public Long count(List<String> searchFields, String keywords, String where) {
            String searchQuery;
            Query q = EbeanContext.server().createQuery(this.modelClass);
            String filter = null;
            if (where != null && !where.trim().equals("")) {
                filter = where.trim();
            }
            if (keywords != null && !keywords.equals("") && !(searchQuery = this.getSearchQuery(searchFields)).equals("")) {
                filter = (filter != null ? "(" + filter + ") and " : "") + "(" + searchQuery + ")";
            }
            if (filter != null) {
                q.where(filter);
                if (filter.indexOf(":keywords") != -1) {
                    q.setParameter("keywords", (Object)("%" + keywords.toLowerCase() + "%"));
                }
            }
            return q.findRowCount();
        }

        public void deleteAll() {
            String query = "delete from " + this.modelClass.getSimpleName();
            Update deleteAll = EbeanContext.server().createUpdate(this.modelClass, query);
            deleteAll.execute();
        }

        public List<Model.Property> listProperties() {
            ArrayList<Model.Property> properties = new ArrayList<Model.Property>();
            HashSet fields = new HashSet();
            Class<? extends EbeanSupport> tclazz = this.modelClass;
            while (!tclazz.equals(Object.class)) {
                Collections.addAll(fields, tclazz.getDeclaredFields());
                tclazz = tclazz.getSuperclass();
            }
            for (Field f : fields) {
                Model.Property mp;
                if (Modifier.isStatic(f.getModifiers()) || f.getName().toLowerCase().startsWith("_ebean") || (mp = this.buildProperty(f)) == null) continue;
                properties.add(mp);
            }
            return properties;
        }

        private Field keyField() {
            Class<? extends EbeanSupport> c = this.modelClass;
            try {
                while (!c.equals(EbeanSupport.class)) {
                    for (Field field : c.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(Id.class)) continue;
                        field.setAccessible(true);
                        return field;
                    }
                    c = c.getSuperclass();
                }
            }
            catch (Exception e) {
                throw new UnexpectedException("Error while determining the object @Id for an object of type " + this.modelClass);
            }
            throw new UnexpectedException("Cannot get the object @Id for an object of type " + this.modelClass);
        }

        Model.Property buildProperty(final Field field) {
            Model.Property modelProperty = new Model.Property();
            modelProperty.type = field.getType();
            modelProperty.field = field;
            if (Model.class.isAssignableFrom(field.getType())) {
                if (field.isAnnotationPresent(OneToOne.class) && field.getAnnotation(OneToOne.class).mappedBy().equals("")) {
                    modelProperty.isRelation = true;
                    modelProperty.relationType = field.getType();
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            List result = EbeanContext.server().find(field.getType()).findList();
                            return result;
                        }
                    };
                }
                if (field.isAnnotationPresent(ManyToOne.class)) {
                    modelProperty.isRelation = true;
                    modelProperty.relationType = field.getType();
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            List result = EbeanContext.server().find(field.getType()).findList();
                            return result;
                        }
                    };
                }
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                final Class fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                if (field.isAnnotationPresent(OneToMany.class) && field.getAnnotation(OneToMany.class).mappedBy().equals("")) {
                    modelProperty.isRelation = true;
                    modelProperty.isMultiple = true;
                    modelProperty.relationType = fieldType;
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            List result = EbeanContext.server().find(fieldType).findList();
                            return result;
                        }
                    };
                }
                if (field.isAnnotationPresent(ManyToMany.class) && field.getAnnotation(ManyToMany.class).mappedBy().equals("")) {
                    modelProperty.isRelation = true;
                    modelProperty.isMultiple = true;
                    modelProperty.relationType = fieldType;
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            List result = EbeanContext.server().find(fieldType).findList();
                            return result;
                        }
                    };
                }
            }
            if (field.getType().isEnum()) {
                modelProperty.choices = new Model.Choices(){

                    public List<Object> list() {
                        return Arrays.asList(field.getType().getEnumConstants());
                    }
                };
            }
            modelProperty.name = field.getName();
            if (field.getType().equals(String.class)) {
                modelProperty.isSearchable = true;
            }
            if (field.isAnnotationPresent(GeneratedValue.class)) {
                modelProperty.isGenerated = true;
            }
            return modelProperty;
        }

        String getSearchQuery(List<String> searchFields) {
            String q = "";
            for (Model.Property property : this.listProperties()) {
                if (!property.isSearchable || searchFields != null && !searchFields.isEmpty() && !searchFields.contains(property.name)) continue;
                if (!q.equals("")) {
                    q = q + " or ";
                }
                q = q + "lower(" + property.name + ") like :keywords";
            }
            return q;
        }
    }
}

