/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cache;

import com.avaje.ebean.annotation.CacheTuning;
import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheOptions;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheHolder {
    private final ConcurrentHashMap<Class<?>, ServerCache> concMap = new ConcurrentHashMap();
    private final HashMap<Class<?>, ServerCache> synchMap = new HashMap();
    private final Object monitor = new Object();
    private final ServerCacheFactory cacheFactory;
    private final ServerCacheOptions defaultOptions;
    private final boolean useBeanTuning;

    public DefaultCacheHolder(ServerCacheFactory cacheFactory, ServerCacheOptions defaultOptions, boolean useBeanTuning) {
        this.cacheFactory = cacheFactory;
        this.defaultOptions = defaultOptions;
        this.useBeanTuning = useBeanTuning;
    }

    public ServerCacheOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerCache getCache(Class<?> beanType) {
        ServerCache cache = this.concMap.get(beanType);
        if (cache != null) {
            return cache;
        }
        Object object = this.monitor;
        synchronized (object) {
            cache = this.synchMap.get(beanType);
            if (cache == null) {
                ServerCacheOptions options = this.getCacheOptions(beanType);
                cache = this.cacheFactory.createCache(beanType, options);
                this.synchMap.put(beanType, cache);
                this.concMap.put(beanType, cache);
            }
            return cache;
        }
    }

    public boolean isCaching(Class<?> beanType) {
        return this.concMap.containsKey(beanType);
    }

    public void clearAll() {
        for (ServerCache serverCache : this.concMap.values()) {
            serverCache.clear();
        }
    }

    private ServerCacheOptions getCacheOptions(Class<?> beanType) {
        CacheTuning cacheTuning;
        if (this.useBeanTuning && (cacheTuning = beanType.getAnnotation(CacheTuning.class)) != null) {
            ServerCacheOptions o = new ServerCacheOptions(cacheTuning);
            o.applyDefaults(this.defaultOptions);
            return o;
        }
        return this.defaultOptions.copy();
    }
}

