/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.ddl;

import com.avaje.ebean.config.dbplatform.DbDdlSyntax;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebeaninternal.server.ddl.BaseTablePropertyVisitor;
import com.avaje.ebeaninternal.server.ddl.CreateIntersectionTable;
import com.avaje.ebeaninternal.server.ddl.CreateTableVisitor;
import com.avaje.ebeaninternal.server.ddl.DdlGenContext;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompound;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;
import com.avaje.ebeaninternal.server.deploy.id.ImportedId;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableColumnVisitor
extends BaseTablePropertyVisitor {
    private static final Logger logger = Logger.getLogger(CreateTableColumnVisitor.class.getName());
    private final DdlGenContext ctx;
    private final DbDdlSyntax ddl;
    private final CreateTableVisitor parent;

    public CreateTableColumnVisitor(CreateTableVisitor parent, DdlGenContext ctx) {
        this.parent = parent;
        this.ctx = ctx;
        this.ddl = ctx.getDdlSyntax();
    }

    @Override
    public void visitMany(BeanPropertyAssocMany<?> p) {
        TableJoin intersectionTableJoin;
        String intTable;
        if (p.isManyToMany() && p.getMappedBy() == null && this.ctx.isProcessIntersectionTable(intTable = (intersectionTableJoin = p.getIntersectionTableJoin()).getTable())) {
            new CreateIntersectionTable(this.ctx, p).build();
        }
    }

    @Override
    public void visitCompoundScalar(BeanPropertyCompound compound, BeanProperty p) {
        this.visitScalar(p);
    }

    @Override
    public void visitCompound(BeanPropertyCompound p) {
    }

    @Override
    public void visitEmbeddedScalar(BeanProperty p, BeanPropertyAssocOne<?> embedded) {
        this.visitScalar(p);
    }

    private StringBuilder createUniqueConstraintBuffer(String table, String column) {
        String uqConstraintName = "uq_" + table + "_" + column;
        if (uqConstraintName.length() > this.ddl.getMaxConstraintNameLength()) {
            uqConstraintName = uqConstraintName.substring(0, this.ddl.getMaxConstraintNameLength());
        }
        StringBuilder constraintExpr = new StringBuilder();
        constraintExpr.append("constraint ").append(uqConstraintName).append(" unique (");
        return constraintExpr;
    }

    @Override
    public void visitOneImported(BeanPropertyAssocOne<?> p) {
        ImportedId importedId = p.getImportedId();
        TableJoinColumn[] columns = p.getTableJoin().columns();
        if (columns.length == 0) {
            String msg = "No join columns for " + p.getFullBeanName();
            throw new RuntimeException(msg);
        }
        StringBuilder constraintExpr = this.createUniqueConstraintBuffer(p.getBeanDescriptor().getBaseTable(), columns[0].getLocalDbColumn());
        for (int i = 0; i < columns.length; ++i) {
            String dbCol = columns[i].getLocalDbColumn();
            if (i > 0) {
                constraintExpr.append(", ");
            }
            constraintExpr.append(dbCol);
            if (this.parent.isDbColumnWritten(dbCol)) continue;
            this.parent.writeColumnName(dbCol, p);
            BeanProperty importedProperty = importedId.findMatchImport(dbCol);
            if (importedProperty == null) {
                throw new RuntimeException("Imported BeanProperty not found?");
            }
            String columnDefn = this.ctx.getColumnDefn(importedProperty);
            this.ctx.write(columnDefn);
            if (!p.isNullable()) {
                this.ctx.write(" not null");
            }
            this.ctx.write(",").writeNewLine();
        }
        constraintExpr.append(")");
        if (p.isOneToOne() && this.ddl.isAddOneToOneUniqueContraint()) {
            this.parent.addUniqueConstraint(constraintExpr.toString());
        }
    }

    @Override
    public void visitScalar(BeanProperty p) {
        if (p.isSecondaryTable()) {
            return;
        }
        if (this.parent.isDbColumnWritten(p.getDbColumn())) {
            return;
        }
        this.parent.writeColumnName(p.getDbColumn(), p);
        String columnDefn = this.ctx.getColumnDefn(p);
        this.ctx.write(columnDefn);
        if (!p.isNullable() || p.isDDLNotNull()) {
            this.ctx.write(" not null");
        }
        if (this.isIdentity(p)) {
            this.writeIdentity();
        }
        if (p.isUnique() && !p.isId()) {
            this.parent.addUniqueConstraint(this.createUniqueConstraint(p));
        }
        this.parent.addCheckConstraint(p);
        this.ctx.write(",").writeNewLine();
    }

    private String createUniqueConstraint(BeanProperty p) {
        StringBuilder expr = this.createUniqueConstraintBuffer(p.getBeanDescriptor().getBaseTable(), p.getDbColumn());
        expr.append(p.getDbColumn()).append(")");
        return expr.toString();
    }

    protected void writeIdentity() {
        String identity = this.ddl.getIdentity();
        if (identity != null && identity.length() > 0) {
            this.ctx.write(" ").write(identity);
        }
    }

    protected boolean isIdentity(BeanProperty p) {
        if (p.isId()) {
            try {
                int jdbcType;
                IdType idType = p.getBeanDescriptor().getIdType();
                if (idType.equals((Object)IdType.IDENTITY) && ((jdbcType = p.getScalarType().getJdbcType()) == 4 || jdbcType == -5 || jdbcType == 5)) {
                    return true;
                }
            }
            catch (Exception e) {
                String msg = "Error determining identity on property " + p.getFullBeanName();
                logger.log(Level.SEVERE, msg, e);
            }
        }
        return false;
    }
}

