/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.sql;

public class TransactionIsolation {
    public static int getLevel(String level) {
        if ("NONE".equalsIgnoreCase(level = level.toUpperCase())) {
            return 0;
        }
        if ("READ_COMMITTED".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("READCOMMITTED".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("READ_UNCOMMITTED".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("READUNCOMMITTED".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("REPEATABLE_READ".equalsIgnoreCase(level)) {
            return 4;
        }
        if ("REPEATABLEREAD".equalsIgnoreCase(level)) {
            return 4;
        }
        if ("SERIALIZABLE".equalsIgnoreCase(level)) {
            return 8;
        }
        if ("SERIALISABLE".equalsIgnoreCase(level)) {
            return 8;
        }
        throw new RuntimeException("Transaction Isolaction level [" + level + "] is not known.");
    }

    public static String getLevelDescription(int level) {
        switch (level) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
            case -1: {
                return "NotSet";
            }
        }
        throw new RuntimeException("Transaction Isolaction level [" + level + "] is not defined.");
    }
}

