/*
 * Decompiled with CFR 0.152.
 */
package play.modules.ebean;

import com.avaje.ebean.enhance.agent.ClassBytesReader;
import com.avaje.ebean.enhance.agent.InputStreamTransform;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.exceptions.UnexpectedException;
import play.modules.ebean.PlayAwareTransformer;

public class EbeanEnhancer
extends Enhancer {
    static ClassFileTransformer transformer = new PlayAwareTransformer(new PlayClassBytesReader(), "transientInternalFields=true;debug=0");

    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        CtClass ctClass;
        byte[] buffer = transformer.transform((ClassLoader)Play.classloader, applicationClass.name, null, null, applicationClass.enhancedByteCode);
        if (buffer != null) {
            applicationClass.enhancedByteCode = buffer;
        }
        if (!(ctClass = this.makeClass(applicationClass)).subtypeOf(this.classPool.get("play.modules.ebean.EbeanSupport"))) {
            return;
        }
        if (!this.hasAnnotation(ctClass, "javax.persistence.Entity")) {
            return;
        }
        String entityName = ctClass.getName();
        try {
            boolean hasDefaultConstructor = false;
            for (CtConstructor constructor : ctClass.getConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                hasDefaultConstructor = true;
                break;
            }
            if (!hasDefaultConstructor && !ctClass.isInterface()) {
                CtConstructor defaultConstructor = CtNewConstructor.make((String)("private " + ctClass.getSimpleName() + "() {}"), (CtClass)ctClass);
                ctClass.addConstructor(defaultConstructor);
            }
        }
        catch (Throwable t) {
            Logger.error((Throwable)t, (String)"Error in EbeanEnhancer", (Object[])new Object[0]);
            throw new UnexpectedException("Error in EbeanEnhancer", t);
        }
        ctClass.addMethod(CtMethod.make((String)("public static play.modules.ebean.EbeanSupport create(String name, play.mvc.Scope.Params params) { return create(" + entityName + ".class,name, params.all(), null); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static long count() { return (long) ebean().createQuery(" + entityName + ".class).findRowCount(); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static long count(String query, Object[] params) { return (long) createQuery(" + entityName + ".class,query,params).findRowCount(); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static java.util.List findAll() { return ebean().createQuery(" + entityName + ".class).findList(); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static play.modules.ebean.EbeanSupport findById(Object id) { return (" + entityName + ") ebean().find(" + entityName + ".class, id); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static play.modules.ebean.EbeanSupport findUnique(String query, Object[] params) { return (" + entityName + ") createQuery(" + entityName + ".class,query,params).findUnique(); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static com.avaje.ebean.Query find(String query, Object[] params) { return createQuery(" + entityName + ".class,query,params); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static com.avaje.ebean.Query all() { return ebean().createQuery(" + entityName + ".class); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static int delete(String query, Object[] params) { return createDeleteQuery(" + entityName + ".class,query,params).execute(); }"), (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)("public static int deleteAll() { return  createDeleteQuery(" + entityName + ".class,null,null).execute(); }"), (CtClass)ctClass));
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.defrost();
        Logger.debug((String)"EBEAN: Class '%s' has been enhanced", (Object[])new Object[]{ctClass.getName()});
    }

    static class PlayClassBytesReader
    implements ClassBytesReader {
        PlayClassBytesReader() {
        }

        public byte[] getClassBytes(String className, ClassLoader classLoader) {
            ApplicationClasses.ApplicationClass ac = Play.classes.getApplicationClass(className.replace("/", "."));
            return ac != null ? ac.enhancedByteCode : this.getBytesFromClassPath(className);
        }

        private byte[] getBytesFromClassPath(String className) {
            String resource = className + ".class";
            byte[] classBytes = null;
            InputStream is = Play.classloader.getResourceAsStream(resource);
            try {
                classBytes = InputStreamTransform.readBytes((InputStream)is);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException reading bytes for " + className, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error closing InputStream for " + className, e);
                    }
                }
            }
            return classBytes;
        }
    }
}

