package play.modules.ebean;

import javax.sql.DataSource;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.IdGenerator;
import com.avaje.ebean.config.dbplatform.IdType;

public class HSQLPlatform extends DatabasePlatform {

    public HSQLPlatform(){
        super();
        this.name = "hsqldb";
        
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsIdentity(true);
        this.dbIdentity.setSupportsGetGeneratedKeys(false);
        this.dbIdentity.setSelectLastInsertedIdTemplate("CALL IDENTITY()");
        
        this.openQuote = "\"";
        this.closeQuote = "\"";
        
        dbDdlSyntax.setDropIfExists("if exists");
        dbDdlSyntax.setIdentity("generated by default as identity");
    }

  @Override
  public IdGenerator createSequenceIdGenerator(BackgroundExecutor be,DataSource ds, String seqName, int batchSize) {
    
    return null;
  }
    
    

}