/**
 * Copyright (C) 2010  Lyubomir Ivanov
 * 
 * This file is part of Ebean Plugin for the PLay! Framework.
 * 
 * Ebean Plugin is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *  
 * Ebean Plugin is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Ebean which is distributed with this plugin.
 * if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA  
 */

package play.modules.ebean;

import java.util.HashMap;
import java.util.Map;

import com.avaje.ebean.EbeanServer;

public class EbeanContext
{
  public static ThreadLocal<EbeanContext> local      = new ThreadLocal<EbeanContext>();

  private EbeanServer              server;
  private Map<String, Object>      properties = new HashMap<String, Object>();

  private EbeanContext(EbeanServer server, Object... props)
  {
    this.server = server;
    for (int i = 0; i < props.length - 1; i += 2)
      properties.put(props[i].toString(), props[i + 1]);
  }

  public static EbeanContext set(EbeanServer server, Object... properties)
  {
    EbeanContext result = new EbeanContext(server, properties);
    local.set(result);
    return result;
  }

  public static EbeanContext get()
  {
    EbeanContext result = local.get();
    if (result == null) {
      throw new IllegalStateException("The Ebean context is not initialized.");
    }
    return result;
  }

  public static EbeanServer server()
  {
    return get().server;
  }

  public static Object getProperty(String propertyName)
  {
    return get().properties.get(propertyName);
  }

  public static void setProperty(String propertyName, Object object)
  {
    get().properties.put(propertyName,object);
  }
}
