/**
 * Copyright (C) 2010  Lyubomir Ivanov
 * 
 * This file is part of Ebean Plugin for the PLay! Framework.
 * 
 * Ebean Plugin is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *  
 * Ebean Plugin is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Ebean which is distributed with this plugin.
 * if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA  
 */

package play.modules.ebean;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

// Forces autoCommit=false for database connections. Not supported by configuration in c3p0
public class EbeanDataSourceWrapper implements DataSource
{
  private DataSource target;

  public EbeanDataSourceWrapper(DataSource ds)
  {
    this.target = ds;
  }

  public Connection getConnection() throws SQLException
  {
    Connection result = target.getConnection();
    if (result.getAutoCommit()) result.setAutoCommit(false);
    return result;
  }

  public Connection getConnection(String username, String password) throws SQLException
  {
    Connection result = target.getConnection(username, password);
    if (result.getAutoCommit()) result.setAutoCommit(false);
    return result;
  }

  public PrintWriter getLogWriter() throws SQLException
  {
    return target.getLogWriter();
  }

  public int getLoginTimeout() throws SQLException
  {
    return target.getLoginTimeout();
  }

  public void setLogWriter(PrintWriter out) throws SQLException
  {
    target.setLogWriter(out);
  }

  public void setLoginTimeout(int seconds) throws SQLException
  {
    target.setLoginTimeout(seconds);
  }

  public boolean isWrapperFor(Class<?> ds) throws SQLException
  {
    return target.getClass().equals(ds.getClass());
  }

  @SuppressWarnings("unchecked")
  public <T> T unwrap(Class<T> ds) throws SQLException
  {
    return isWrapperFor(ds) ? (T) target : null;
  }

}
