/**
 * Copyright (C) 2010  Lyubomir Ivanov
 * 
 * This file is part of Ebean Plugin for the PLay! Framework.
 * 
 * Ebean Plugin is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *  
 * Ebean Plugin is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Ebean which is distributed with this plugin.
 * if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA  
 */

package play.modules.ebean;

import java.util.Set;


import com.avaje.ebean.event.BeanPersistAdapter;
import com.avaje.ebean.event.BeanPersistRequest;

public class EbeanModelAdapter extends BeanPersistAdapter
{

  @Override
  public boolean isRegisterFor(Class<?> cls)
  {
    return EbeanPlugin.getRootModelClass().isAssignableFrom(cls);
  }

  @Override
  public void postLoad(Object bean, Set<String> includedProperties)
  {
    ((IEbeanSupport) bean).afterLoad();
  }

  @Override
  public boolean preInsert(BeanPersistRequest<?> request)
  {
    ((IEbeanSupport) request.getBean()).beforeSave(true);
    return true;
  }

  @Override
  public boolean preUpdate(BeanPersistRequest<?> request)
  {
    ((IEbeanSupport) request.getBean()).beforeSave(false);
    return true;
  }

  @Override
  public void postInsert(BeanPersistRequest<?> request)
  {
    ((IEbeanSupport) request.getBean()).afterSave(true);
  }

  @Override
  public void postUpdate(BeanPersistRequest<?> request)
  {
    ((IEbeanSupport) request.getBean()).afterSave(false);
  }
  
  
}
