/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.AdminAutofetch;
import com.avaje.ebean.AdminLogging;
import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.BeanState;
import com.avaje.ebean.CallableSql;
import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.Filter;
import com.avaje.ebean.FutureIds;
import com.avaje.ebean.FutureList;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.InvalidValue;
import com.avaje.ebean.PagingList;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryIterator;
import com.avaje.ebean.QueryResultVisitor;
import com.avaje.ebean.SqlFutureList;
import com.avaje.ebean.SqlQuery;
import com.avaje.ebean.SqlRow;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.TxCallable;
import com.avaje.ebean.TxIsolation;
import com.avaje.ebean.TxRunnable;
import com.avaje.ebean.TxScope;
import com.avaje.ebean.TxType;
import com.avaje.ebean.Update;
import com.avaje.ebean.ValuePair;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.CallStack;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.config.EncryptKeyManager;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.ldap.LdapConfig;
import com.avaje.ebean.config.lucene.LuceneIndex;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebean.text.csv.CsvReader;
import com.avaje.ebean.text.json.JsonContext;
import com.avaje.ebean.text.json.JsonElement;
import com.avaje.ebeaninternal.api.LoadBeanRequest;
import com.avaje.ebeaninternal.api.LoadManyRequest;
import com.avaje.ebeaninternal.api.ScopeTrans;
import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiSqlQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.autofetch.AutoFetchManager;
import com.avaje.ebeaninternal.server.core.DefaultBeanLoader;
import com.avaje.ebeaninternal.server.core.DefaultBeanState;
import com.avaje.ebeaninternal.server.core.DefaultCallableSql;
import com.avaje.ebeaninternal.server.core.DefaultSqlUpdate;
import com.avaje.ebeaninternal.server.core.DiffHelp;
import com.avaje.ebeaninternal.server.core.InternalConfiguration;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.OrmQueryEngine;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.core.Persister;
import com.avaje.ebeaninternal.server.core.ProxyBeanObjectInputStream;
import com.avaje.ebeaninternal.server.core.PstmtBatch;
import com.avaje.ebeaninternal.server.core.RelationalQueryEngine;
import com.avaje.ebeaninternal.server.core.RelationalQueryRequest;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.core.TransWrapper;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.deploy.BeanManager;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.DNativeQuery;
import com.avaje.ebeaninternal.server.deploy.DeployNamedQuery;
import com.avaje.ebeaninternal.server.deploy.DeployNamedUpdate;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.el.ElFilter;
import com.avaje.ebeaninternal.server.jmx.MAdminAutofetch;
import com.avaje.ebeaninternal.server.ldap.DefaultLdapOrmQuery;
import com.avaje.ebeaninternal.server.ldap.LdapOrmQueryEngine;
import com.avaje.ebeaninternal.server.ldap.LdapOrmQueryRequest;
import com.avaje.ebeaninternal.server.ldap.expression.LdapExpressionFactory;
import com.avaje.ebeaninternal.server.lib.ShutdownManager;
import com.avaje.ebeaninternal.server.lucene.LuceneIndexManager;
import com.avaje.ebeaninternal.server.query.CQuery;
import com.avaje.ebeaninternal.server.query.CQueryEngine;
import com.avaje.ebeaninternal.server.query.CallableQueryIds;
import com.avaje.ebeaninternal.server.query.CallableQueryList;
import com.avaje.ebeaninternal.server.query.CallableQueryRowCount;
import com.avaje.ebeaninternal.server.query.CallableSqlQueryList;
import com.avaje.ebeaninternal.server.query.LimitOffsetPagingQuery;
import com.avaje.ebeaninternal.server.query.QueryFutureIds;
import com.avaje.ebeaninternal.server.query.QueryFutureList;
import com.avaje.ebeaninternal.server.query.QueryFutureRowCount;
import com.avaje.ebeaninternal.server.query.SqlQueryFutureList;
import com.avaje.ebeaninternal.server.querydefn.DefaultOrmQuery;
import com.avaje.ebeaninternal.server.querydefn.DefaultOrmUpdate;
import com.avaje.ebeaninternal.server.querydefn.DefaultRelationalQuery;
import com.avaje.ebeaninternal.server.querydefn.NaturalKeyBindParam;
import com.avaje.ebeaninternal.server.text.csv.TCsvReader;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import com.avaje.ebeaninternal.server.transaction.TransactionScopeManager;
import com.avaje.ebeaninternal.util.ParamTypeHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultServer
implements SpiEbeanServer {
    private static final Logger logger = Logger.getLogger(DefaultServer.class.getName());
    private static final InvalidValue[] EMPTY_INVALID_VALUES = new InvalidValue[0];
    private final String serverName;
    private final DatabasePlatform databasePlatform;
    private final AdminLogging adminLogging;
    private final AdminAutofetch adminAutofetch;
    private final TransactionManager transactionManager;
    private final TransactionScopeManager transactionScopeManager;
    private final int maxCallStack;
    private final boolean rollbackOnChecked;
    private final boolean defaultDeleteMissingChildren;
    private final boolean defaultUpdateNullProperties;
    private final boolean vanillaMode;
    private final boolean vanillaRefMode;
    private final LdapOrmQueryEngine ldapQueryEngine;
    private final Persister persister;
    private final OrmQueryEngine queryEngine;
    private final RelationalQueryEngine relationalQueryEngine;
    private final ServerCacheManager serverCacheManager;
    private final BeanDescriptorManager beanDescriptorManager;
    private final DiffHelp diffHelp = new DiffHelp();
    private final AutoFetchManager autoFetchManager;
    private final CQueryEngine cqueryEngine;
    private final DdlGenerator ddlGenerator;
    private final ExpressionFactory ldapExpressionFactory = new LdapExpressionFactory();
    private final ExpressionFactory expressionFactory;
    private final SpiBackgroundExecutor backgroundExecutor;
    private final DefaultBeanLoader beanLoader;
    private final EncryptKeyManager encryptKeyManager;
    private final JsonContext jsonContext;
    private final LuceneIndexManager luceneIndexManager;
    private String mbeanName;
    private MBeanServer mbeanServer;
    private int lazyLoadBatchSize;
    private int queryBatchSize;
    private PstmtBatch pstmtBatch;
    private static final int IGNORE_LEADING_ELEMENTS = 5;
    private static final String AVAJE_EBEAN = Ebean.class.getName().substring(0, 15);

    public DefaultServer(InternalConfiguration config, ServerCacheManager cache) {
        this.vanillaMode = config.getServerConfig().isVanillaMode();
        this.vanillaRefMode = config.getServerConfig().isVanillaRefMode();
        this.serverCacheManager = cache;
        this.pstmtBatch = config.getPstmtBatch();
        this.databasePlatform = config.getDatabasePlatform();
        this.backgroundExecutor = config.getBackgroundExecutor();
        this.serverName = config.getServerConfig().getName();
        this.lazyLoadBatchSize = config.getServerConfig().getLazyLoadBatchSize();
        this.queryBatchSize = config.getServerConfig().getQueryBatchSize();
        this.cqueryEngine = config.getCQueryEngine();
        this.expressionFactory = config.getExpressionFactory();
        this.adminLogging = config.getLogControl();
        this.encryptKeyManager = config.getServerConfig().getEncryptKeyManager();
        this.beanDescriptorManager = config.getBeanDescriptorManager();
        this.beanDescriptorManager.setEbeanServer(this);
        this.maxCallStack = GlobalProperties.getInt("ebean.maxCallStack", 5);
        this.defaultUpdateNullProperties = "true".equalsIgnoreCase(config.getServerConfig().getProperty("defaultUpdateNullProperties", "false"));
        this.defaultDeleteMissingChildren = "true".equalsIgnoreCase(config.getServerConfig().getProperty("defaultDeleteMissingChildren", "true"));
        this.rollbackOnChecked = GlobalProperties.getBoolean("ebean.transaction.rollbackOnChecked", true);
        this.transactionManager = config.getTransactionManager();
        this.transactionScopeManager = config.getTransactionScopeManager();
        this.persister = config.createPersister(this);
        this.queryEngine = config.createOrmQueryEngine();
        this.relationalQueryEngine = config.createRelationalQueryEngine();
        this.autoFetchManager = config.createAutoFetchManager(this);
        this.adminAutofetch = new MAdminAutofetch(this.autoFetchManager);
        this.ddlGenerator = new DdlGenerator(this, config.getDatabasePlatform(), config.getServerConfig());
        this.beanLoader = new DefaultBeanLoader(this, config.getDebugLazyLoad());
        this.jsonContext = config.createJsonContext(this);
        LdapConfig ldapConfig = config.getServerConfig().getLdapConfig();
        this.ldapQueryEngine = ldapConfig == null ? null : new LdapOrmQueryEngine(ldapConfig.isVanillaMode(), ldapConfig.getContextFactory());
        this.luceneIndexManager = config.getLuceneIndexManager();
        this.luceneIndexManager.setServer(this);
        ShutdownManager.register(new Shutdown());
    }

    @Override
    public LuceneIndexManager getLuceneIndexManager() {
        return this.luceneIndexManager;
    }

    @Override
    public LuceneIndex getLuceneIndex(Class<?> beanType) {
        return this.luceneIndexManager.getIndex(beanType.getName());
    }

    @Override
    public boolean isDefaultDeleteMissingChildren() {
        return this.defaultDeleteMissingChildren;
    }

    @Override
    public boolean isDefaultUpdateNullProperties() {
        return this.defaultUpdateNullProperties;
    }

    @Override
    public boolean isVanillaMode() {
        return this.vanillaMode;
    }

    @Override
    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    @Override
    public PstmtBatch getPstmtBatch() {
        return this.pstmtBatch;
    }

    @Override
    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    @Override
    public BackgroundExecutor getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    @Override
    public DdlGenerator getDdlGenerator() {
        return this.ddlGenerator;
    }

    @Override
    public AdminLogging getAdminLogging() {
        return this.adminLogging;
    }

    @Override
    public AdminAutofetch getAdminAutofetch() {
        return this.adminAutofetch;
    }

    @Override
    public AutoFetchManager getAutoFetchManager() {
        return this.autoFetchManager;
    }

    public void initialise() {
        if (this.encryptKeyManager != null) {
            this.encryptKeyManager.initialise();
        }
        List<BeanDescriptor<?>> list = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).cacheInitialise();
        }
    }

    public void start() {
        this.luceneIndexManager.start();
    }

    public void registerMBeans(MBeanServer mbeanServer, int uniqueServerId) {
        ObjectName autofethcName;
        ObjectName adminName;
        this.mbeanServer = mbeanServer;
        this.mbeanName = "Ebean:server=" + this.serverName + uniqueServerId;
        try {
            adminName = new ObjectName(this.mbeanName + ",function=Logging");
            autofethcName = new ObjectName(this.mbeanName + ",key=AutoFetch");
        }
        catch (Exception e) {
            String msg = "Failed to register the JMX beans for Ebean server [" + this.serverName + "].";
            logger.log(Level.SEVERE, msg, e);
            return;
        }
        try {
            mbeanServer.registerMBean(this.adminLogging, adminName);
            mbeanServer.registerMBean(this.adminAutofetch, autofethcName);
        }
        catch (InstanceAlreadyExistsException e) {
            String msg = "JMX beans for Ebean server [" + this.serverName + "] already registered. Will try unregister/register" + e.getMessage();
            logger.log(Level.WARNING, msg);
            try {
                mbeanServer.unregisterMBean(adminName);
                mbeanServer.unregisterMBean(autofethcName);
                mbeanServer.registerMBean(this.adminLogging, adminName);
                mbeanServer.registerMBean(this.adminAutofetch, autofethcName);
            }
            catch (Exception ae) {
                String amsg = "Unable to unregister/register the JMX beans for Ebean server [" + this.serverName + "].";
                logger.log(Level.SEVERE, amsg, ae);
            }
        }
        catch (Exception e) {
            String msg = "Error registering MBean[" + this.mbeanName + "]";
            logger.log(Level.SEVERE, msg, e);
        }
    }

    @Override
    public String getName() {
        return this.serverName;
    }

    @Override
    public BeanState getBeanState(Object bean) {
        if (bean instanceof EntityBean) {
            return new DefaultBeanState((EntityBean)bean);
        }
        return null;
    }

    @Override
    public void runCacheWarming() {
        List<BeanDescriptor<?>> descList = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < descList.size(); ++i) {
            descList.get(i).runCacheWarming();
        }
    }

    @Override
    public void runCacheWarming(Class<?> beanType) {
        BeanDescriptor<?> desc = this.beanDescriptorManager.getBeanDescriptor(beanType);
        if (desc == null) {
            String msg = "Is " + beanType + " an entity? Could not find a BeanDescriptor";
            throw new PersistenceException(msg);
        }
        desc.runCacheWarming();
    }

    @Override
    public <T> CQuery<T> compileQuery(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> qr = this.createQueryRequest(SpiQuery.Type.SUBQUERY, query, t);
        OrmQueryRequest orm = (OrmQueryRequest)qr;
        return this.cqueryEngine.buildQuery(orm);
    }

    @Override
    public CQueryEngine getQueryEngine() {
        return this.cqueryEngine;
    }

    @Override
    public ServerCacheManager getServerCacheManager() {
        return this.serverCacheManager;
    }

    public AutoFetchManager getProfileListener() {
        return this.autoFetchManager;
    }

    public RelationalQueryEngine getRelationalQueryEngine() {
        return this.relationalQueryEngine;
    }

    public void refreshMany(Object parentBean, String propertyName, Transaction t) {
        this.beanLoader.refreshMany(parentBean, propertyName, t);
    }

    @Override
    public void refreshMany(Object parentBean, String propertyName) {
        this.beanLoader.refreshMany(parentBean, propertyName);
    }

    @Override
    public void loadMany(LoadManyRequest loadRequest) {
        this.beanLoader.loadMany(loadRequest);
    }

    @Override
    public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
        this.beanLoader.loadMany(bc, null, onlyIds);
    }

    @Override
    public void refresh(Object bean) {
        this.beanLoader.refresh(bean);
    }

    @Override
    public void loadBean(LoadBeanRequest loadRequest) {
        this.beanLoader.loadBean(loadRequest);
    }

    @Override
    public void loadBean(EntityBeanIntercept ebi) {
        this.beanLoader.loadBean(ebi);
    }

    @Override
    public InvalidValue validate(Object bean) {
        if (bean == null) {
            return null;
        }
        BeanDescriptor<?> beanDescriptor = this.getBeanDescriptor(bean.getClass());
        return beanDescriptor.validate(true, bean);
    }

    @Override
    public InvalidValue[] validate(Object bean, String propertyName, Object value) {
        List<InvalidValue> errors;
        if (bean == null) {
            return null;
        }
        BeanDescriptor<?> beanDescriptor = this.getBeanDescriptor(bean.getClass());
        BeanProperty prop = beanDescriptor.getBeanProperty(propertyName);
        if (prop == null) {
            String msg = "property " + propertyName + " was not found?";
            throw new PersistenceException(msg);
        }
        if (value == null) {
            value = prop.getValue(bean);
        }
        if ((errors = prop.validate(true, value)) == null) {
            return EMPTY_INVALID_VALUES;
        }
        return InvalidValue.toArray(errors);
    }

    @Override
    public Map<String, ValuePair> diff(Object a, Object b) {
        if (a == null) {
            return null;
        }
        BeanDescriptor<?> desc = this.getBeanDescriptor(a.getClass());
        return this.diffHelp.diff(a, b, desc);
    }

    @Override
    public void externalModification(TransactionEventTable tableEvent) {
        SpiTransaction t = this.transactionScopeManager.get();
        if (t != null) {
            t.getEvent().add(tableEvent);
        } else {
            this.transactionManager.externalModification(tableEvent);
        }
    }

    @Override
    public void externalModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        TransactionEventTable evt = new TransactionEventTable();
        evt.add(tableName, inserts, updates, deletes);
        this.externalModification(evt);
    }

    @Override
    public void clearQueryStatistics() {
        for (BeanDescriptor<?> desc : this.getBeanDescriptors()) {
            desc.clearQueryStatistics();
        }
    }

    @Override
    public <T> T createEntityBean(Class<T> type) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(type);
        return (T)desc.createEntityBean();
    }

    @Override
    public ObjectInputStream createProxyObjectInputStream(InputStream is) {
        try {
            return new ProxyBeanObjectInputStream(is, this);
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Override
    public <T> T getReference(Class<T> type, Object id) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        BeanDescriptor<T> desc = this.getBeanDescriptor(type);
        id = desc.convertId(id);
        Object ref = null;
        PersistenceContext ctx = null;
        SpiTransaction t = this.transactionScopeManager.get();
        if (t != null) {
            ctx = t.getPersistenceContext();
            ref = ctx.get(type, id);
        }
        if (ref == null) {
            InheritInfo inheritInfo = desc.getInheritInfo();
            if (inheritInfo != null) {
                String idNames;
                Object[] idProps = desc.propertiesId();
                switch (idProps.length) {
                    case 0: {
                        throw new PersistenceException("No ID properties for this type? " + desc);
                    }
                    case 1: {
                        idNames = ((BeanProperty)idProps[0]).getName();
                        break;
                    }
                    default: {
                        idNames = Arrays.toString(idProps);
                        idNames = idNames.substring(1, idNames.length() - 1);
                    }
                }
                Query<T> query = this.createQuery(type);
                query.select(idNames).setId(id);
                ref = query.findUnique();
            } else {
                ref = desc.createReference(this.vanillaRefMode, null, id, null);
            }
            if (ctx != null && ref instanceof EntityBean) {
                ctx.put(id, ref);
            }
        }
        return (T)ref;
    }

    @Override
    public Transaction createTransaction() {
        return this.transactionManager.createTransaction(true, -1);
    }

    @Override
    public Transaction createTransaction(TxIsolation isolation) {
        return this.transactionManager.createTransaction(true, isolation.getLevel());
    }

    @Override
    public void logComment(String msg) {
        SpiTransaction t = this.transactionScopeManager.get();
        if (t != null) {
            t.log(msg);
        }
    }

    @Override
    public <T> T execute(TxCallable<T> c) {
        return this.execute(null, c);
    }

    @Override
    public <T> T execute(TxScope scope, TxCallable<T> c) {
        ScopeTrans scopeTrans = this.createScopeTrans(scope);
        try {
            T t = c.call();
            return t;
        }
        catch (Error e) {
            throw scopeTrans.caughtError(e);
        }
        catch (RuntimeException e) {
            throw scopeTrans.caughtThrowable(e);
        }
        finally {
            scopeTrans.onFinally();
        }
    }

    @Override
    public void execute(TxRunnable r) {
        this.execute(null, r);
    }

    @Override
    public void execute(TxScope scope, TxRunnable r) {
        ScopeTrans scopeTrans = this.createScopeTrans(scope);
        try {
            r.run();
        }
        catch (Error e) {
            throw scopeTrans.caughtError(e);
        }
        catch (RuntimeException e) {
            throw scopeTrans.caughtThrowable(e);
        }
        finally {
            scopeTrans.onFinally();
        }
    }

    private boolean createNewTransaction(SpiTransaction t, TxScope scope) {
        TxType type = scope.getType();
        switch (type) {
            case REQUIRED: {
                return t == null;
            }
            case REQUIRES_NEW: {
                return true;
            }
            case MANDATORY: {
                if (t == null) {
                    throw new PersistenceException("Transaction missing when MANDATORY");
                }
                return true;
            }
            case NEVER: {
                if (t != null) {
                    throw new PersistenceException("Transaction exists for Transactional NEVER");
                }
                return false;
            }
            case SUPPORTS: {
                return false;
            }
            case NOT_SUPPORTED: {
                throw new RuntimeException("NOT_SUPPORTED should already be handled?");
            }
        }
        throw new RuntimeException("Should never get here?");
    }

    @Override
    public ScopeTrans createScopeTrans(TxScope txScope) {
        boolean newTransaction;
        if (txScope == null) {
            txScope = new TxScope();
        }
        SpiTransaction suspended = null;
        SpiTransaction t = this.transactionScopeManager.get();
        if (txScope.getType().equals((Object)TxType.NOT_SUPPORTED)) {
            newTransaction = false;
            suspended = t;
            t = null;
        } else {
            newTransaction = this.createNewTransaction(t, txScope);
            if (newTransaction) {
                suspended = t;
                int isoLevel = -1;
                TxIsolation isolation = txScope.getIsolation();
                if (isolation != null) {
                    isoLevel = isolation.getLevel();
                }
                t = this.transactionManager.createTransaction(true, isoLevel);
            }
        }
        this.transactionScopeManager.replace(t);
        return new ScopeTrans(this.rollbackOnChecked, newTransaction, t, txScope, suspended, this.transactionScopeManager);
    }

    @Override
    public SpiTransaction getCurrentServerTransaction() {
        return this.transactionScopeManager.get();
    }

    @Override
    public Transaction beginTransaction() {
        SpiTransaction t = this.transactionManager.createTransaction(true, -1);
        this.transactionScopeManager.set(t);
        return t;
    }

    @Override
    public Transaction beginTransaction(TxIsolation isolation) {
        SpiTransaction t = this.transactionManager.createTransaction(true, isolation.getLevel());
        this.transactionScopeManager.set(t);
        return t;
    }

    @Override
    public Transaction currentTransaction() {
        return this.transactionScopeManager.get();
    }

    @Override
    public void commitTransaction() {
        this.transactionScopeManager.commit();
    }

    @Override
    public void rollbackTransaction() {
        this.transactionScopeManager.rollback();
    }

    @Override
    public void endTransaction() {
        this.transactionScopeManager.end();
    }

    @Override
    public Object nextId(Class<?> beanType) {
        BeanDescriptor<?> desc = this.getBeanDescriptor(beanType);
        return desc.nextId(null);
    }

    @Override
    public <T> void sort(List<T> list, String sortByClause) {
        if (list == null) {
            throw new NullPointerException("list is null");
        }
        if (sortByClause == null) {
            throw new NullPointerException("sortByClause is null");
        }
        if (list.size() == 0) {
            return;
        }
        Class<?> beanType = list.get(0).getClass();
        BeanDescriptor<?> beanDescriptor = this.getBeanDescriptor(beanType);
        if (beanDescriptor == null) {
            String m = "BeanDescriptor not found, is [" + beanType + "] an entity bean?";
            throw new PersistenceException(m);
        }
        beanDescriptor.sort(list, sortByClause);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> beanType) throws PersistenceException {
        return this.createQuery(beanType, null);
    }

    @Override
    public <T> Query<T> createNamedQuery(Class<T> beanType, String namedQuery) throws PersistenceException {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            throw new PersistenceException("Is " + beanType.getName() + " an Entity Bean? BeanDescriptor not found?");
        }
        DeployNamedQuery deployQuery = desc.getNamedQuery(namedQuery);
        if (deployQuery == null) {
            throw new PersistenceException("named query " + namedQuery + " was not found for " + desc.getFullName());
        }
        return new DefaultOrmQuery<T>(beanType, (EbeanServer)this, this.expressionFactory, deployQuery);
    }

    @Override
    public <T> Filter<T> filter(Class<T> beanType) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        return new ElFilter<T>(desc);
    }

    @Override
    public <T> CsvReader<T> createCsvReader(Class<T> beanType) {
        BeanDescriptor<T> descriptor = this.getBeanDescriptor(beanType);
        if (descriptor == null) {
            throw new NullPointerException("BeanDescriptor for " + beanType.getName() + " not found");
        }
        return new TCsvReader<T>(this, descriptor);
    }

    @Override
    public <T> Query<T> find(Class<T> beanType) {
        return this.createQuery(beanType);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> beanType, String query) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        switch (desc.getEntityType()) {
            case SQL: {
                if (query != null) {
                    throw new PersistenceException("You must used Named queries for this Entity " + desc.getFullName());
                }
                DeployNamedQuery defaultSqlSelect = desc.getNamedQuery("default");
                return new DefaultOrmQuery<T>(beanType, (EbeanServer)this, this.expressionFactory, defaultSqlSelect);
            }
            case LDAP: {
                return new DefaultLdapOrmQuery<T>(beanType, (EbeanServer)this, this.ldapExpressionFactory, query);
            }
        }
        return new DefaultOrmQuery<T>(beanType, (EbeanServer)this, this.expressionFactory, query);
    }

    @Override
    public <T> Update<T> createNamedUpdate(Class<T> beanType, String namedUpdate) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        DeployNamedUpdate deployUpdate = desc.getNamedUpdate(namedUpdate);
        if (deployUpdate == null) {
            throw new PersistenceException("named update " + namedUpdate + " was not found for " + desc.getFullName());
        }
        return new DefaultOrmUpdate(beanType, (EbeanServer)this, desc.getBaseTable(), deployUpdate);
    }

    @Override
    public <T> Update<T> createUpdate(Class<T> beanType, String ormUpdate) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        return new DefaultOrmUpdate(beanType, (EbeanServer)this, desc.getBaseTable(), ormUpdate);
    }

    @Override
    public SqlQuery createSqlQuery(String sql) {
        return new DefaultRelationalQuery(this, sql);
    }

    @Override
    public SqlQuery createNamedSqlQuery(String namedQuery) {
        DNativeQuery nq = this.beanDescriptorManager.getNativeQuery(namedQuery);
        if (nq == null) {
            throw new PersistenceException("SqlQuery " + namedQuery + " not found.");
        }
        return new DefaultRelationalQuery(this, nq.getQuery());
    }

    @Override
    public SqlUpdate createSqlUpdate(String sql) {
        return new DefaultSqlUpdate(this, sql);
    }

    @Override
    public CallableSql createCallableSql(String sql) {
        return new DefaultCallableSql(this, sql);
    }

    @Override
    public SqlUpdate createNamedSqlUpdate(String namedQuery) {
        DNativeQuery nq = this.beanDescriptorManager.getNativeQuery(namedQuery);
        if (nq == null) {
            throw new PersistenceException("SqlUpdate " + namedQuery + " not found.");
        }
        return new DefaultSqlUpdate(this, nq.getQuery());
    }

    @Override
    public <T> T find(Class<T> beanType, Object uid) {
        return this.find(beanType, uid, null);
    }

    @Override
    public <T> T find(Class<T> beanType, Object id, Transaction t) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        Query<T> query = this.createQuery(beanType).setId(id);
        return this.findId(query, t);
    }

    private <T> SpiOrmQueryRequest<T> createQueryRequest(SpiQuery.Type type, Query<T> query, Transaction t) {
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setType(type);
        BeanDescriptor desc = this.beanDescriptorManager.getBeanDescriptor(spiQuery.getBeanType());
        spiQuery.setBeanDescriptor(desc);
        return this.createQueryRequest(desc, spiQuery, t);
    }

    @Override
    public <T> SpiOrmQueryRequest<T> createQueryRequest(BeanDescriptor<T> desc, SpiQuery<T> query, Transaction t) {
        if (desc.isLdapEntityType()) {
            return new LdapOrmQueryRequest<T>(query, desc, this.ldapQueryEngine);
        }
        if (desc.isAutoFetchTunable() && !query.isSqlSelect() && !this.autoFetchManager.tuneQuery(query)) {
            query.setDefaultSelectClause();
        }
        if (query.selectAllForLazyLoadProperty() && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Using selectAllForLazyLoadProperty");
        }
        if (query.getParentNode() == null) {
            CallStack callStack = this.createCallStack();
            query.setOrigin(callStack);
        }
        if (query.initManyWhereJoins()) {
            query.setDistinct(true);
        }
        boolean allowOneManyFetch = true;
        if (SpiQuery.Mode.LAZYLOAD_MANY.equals((Object)query.getMode())) {
            allowOneManyFetch = false;
        } else if (query.hasMaxRowsOrFirstRow() && !query.isRawSql() && !query.isSqlSelect() && query.getBackgroundFetchAfter() == 0) {
            allowOneManyFetch = false;
        }
        query.convertManyFetchJoinsToQueryJoins(allowOneManyFetch, this.queryBatchSize);
        SpiTransaction serverTrans = (SpiTransaction)t;
        OrmQueryRequest<T> request = new OrmQueryRequest<T>(this, this.queryEngine, query, desc, serverTrans);
        BeanQueryAdapter queryAdapter = desc.getQueryAdapter();
        if (queryAdapter != null) {
            queryAdapter.preQuery(request);
        }
        request.calculateQueryPlanHash();
        return request;
    }

    private <T> T findIdCheckPersistenceContextAndCache(Transaction transaction, BeanDescriptor<T> beanDescriptor, SpiQuery<T> query) {
        Object o;
        SpiTransaction t = (SpiTransaction)transaction;
        if (t == null) {
            t = this.getCurrentServerTransaction();
        }
        PersistenceContext context = null;
        if (t != null && (context = t.getPersistenceContext()) != null && (o = context.get(beanDescriptor.getBeanType(), query.getId())) != null) {
            return (T)o;
        }
        if (!beanDescriptor.calculateUseCache(query.isUseBeanCache())) {
            return null;
        }
        boolean vanilla = query.isVanillaMode(this.vanillaMode);
        T cachedBean = beanDescriptor.cacheGetBean(query.getId(), vanilla, query.isReadOnly());
        if (cachedBean != null) {
            if (context == null) {
                context = new DefaultPersistenceContext();
            }
            context.put(query.getId(), cachedBean);
        }
        return cachedBean;
    }

    private <T> T findId(Query<T> query, Transaction t) {
        Object bean;
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setType(SpiQuery.Type.BEAN);
        BeanDescriptor desc = this.beanDescriptorManager.getBeanDescriptor(spiQuery.getBeanType());
        spiQuery.setBeanDescriptor(desc);
        if (!spiQuery.isLoadBeanCache() && (bean = this.findIdCheckPersistenceContextAndCache(t, desc, spiQuery)) != null) {
            return bean;
        }
        SpiOrmQueryRequest request = this.createQueryRequest(desc, spiQuery, t);
        try {
            request.initTransIfRequired();
            Object bean2 = request.findId();
            request.endTransIfRequired();
            return (T)bean2;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public <T> T findUnique(Query<T> query, Transaction t) {
        Object id2;
        NaturalKeyBindParam keyBindParam;
        SpiQuery q = (SpiQuery)query;
        Object id = q.getId();
        if (id != null) {
            return this.findId(query, t);
        }
        BeanDescriptor desc = this.beanDescriptorManager.getBeanDescriptor(q.getBeanType());
        if (desc.calculateUseNaturalKeyCache(q.isUseBeanCache()) && (keyBindParam = q.getNaturalKeyBindParam()) != null && desc.cacheIsNaturalKey(keyBindParam.getName()) && (id2 = desc.cacheGetNaturalKeyId(keyBindParam.getValue())) != null) {
            SpiQuery copy = q.copy();
            copy.convertWhereNaturalKeyToId(id2);
            return this.findId(copy, t);
        }
        List<T> list = this.findList(query, t);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            String m = "Unique expecting 0 or 1 rows but got [" + list.size() + "]";
            throw new PersistenceException(m);
        }
        return list.get(0);
    }

    @Override
    public <T> Set<T> findSet(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.SET, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (Set)((Object)result);
        }
        try {
            request.initTransIfRequired();
            Set<?> set = request.findSet();
            request.endTransIfRequired();
            return set;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public <T> Map<?, T> findMap(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.MAP, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (Map)((Object)result);
        }
        try {
            request.initTransIfRequired();
            Map<?, ?> map = request.findMap();
            request.endTransIfRequired();
            return map;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public <T> int findRowCount(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        return this.findRowCountWithCopy(copy, t);
    }

    @Override
    public <T> int findRowCountWithCopy(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ROWCOUNT, query, t);
        try {
            request.initTransIfRequired();
            int rowCount = request.findRowCount();
            request.endTransIfRequired();
            return rowCount;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public <T> List<Object> findIds(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        return this.findIdsWithCopy(copy, t);
    }

    @Override
    public <T> List<Object> findIdsWithCopy(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ID_LIST, query, t);
        try {
            request.initTransIfRequired();
            List<Object> list = request.findIds();
            request.endTransIfRequired();
            return list;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public <T> FutureRowCount<T> findFutureRowCount(Query<T> q, Transaction t) {
        SpiQuery copy = ((SpiQuery)q).copy();
        copy.setFutureFetch(true);
        Transaction newTxn = this.createTransaction();
        CallableQueryRowCount call = new CallableQueryRowCount(this, copy, newTxn);
        FutureTask<Integer> futureTask = new FutureTask<Integer>(call);
        QueryFutureRowCount queryFuture = new QueryFutureRowCount(copy, futureTask);
        this.backgroundExecutor.execute(futureTask);
        return queryFuture;
    }

    @Override
    public <T> FutureIds<T> findFutureIds(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        copy.setFutureFetch(true);
        List<Object> idList = Collections.synchronizedList(new ArrayList());
        copy.setIdList(idList);
        Transaction newTxn = this.createTransaction();
        CallableQueryIds call = new CallableQueryIds(this, copy, newTxn);
        FutureTask<List<Object>> futureTask = new FutureTask<List<Object>>(call);
        QueryFutureIds queryFuture = new QueryFutureIds(copy, futureTask);
        this.backgroundExecutor.execute(futureTask);
        return queryFuture;
    }

    @Override
    public <T> FutureList<T> findFutureList(Query<T> query, Transaction t) {
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setFutureFetch(true);
        if (spiQuery.getPersistenceContext() == null) {
            if (t != null) {
                spiQuery.setPersistenceContext(((SpiTransaction)t).getPersistenceContext());
            } else {
                SpiTransaction st = this.getCurrentServerTransaction();
                if (st != null) {
                    spiQuery.setPersistenceContext(st.getPersistenceContext());
                }
            }
        }
        Transaction newTxn = this.createTransaction();
        CallableQueryList<T> call = new CallableQueryList<T>(this, query, newTxn);
        FutureTask futureTask = new FutureTask(call);
        this.backgroundExecutor.execute(futureTask);
        return new QueryFutureList<T>(query, futureTask);
    }

    @Override
    public <T> PagingList<T> findPagingList(Query<T> query, Transaction t, int pageSize) {
        SpiQuery spiQuery = (SpiQuery)query;
        PersistenceContext pc = spiQuery.getPersistenceContext();
        if (pc == null) {
            SpiTransaction currentTransaction = this.getCurrentServerTransaction();
            if (currentTransaction != null) {
                pc = currentTransaction.getPersistenceContext();
            }
            if (pc == null) {
                pc = new DefaultPersistenceContext();
            }
            spiQuery.setPersistenceContext(pc);
        }
        return new LimitOffsetPagingQuery(this, spiQuery, pageSize);
    }

    @Override
    public <T> void findVisit(Query<T> query, QueryResultVisitor<T> visitor, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.LIST, query, t);
        try {
            request.initTransIfRequired();
            request.findVisit(visitor);
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public <T> QueryIterator<T> findIterate(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.LIST, query, t);
        try {
            request.initTransIfRequired();
            return request.findIterate();
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public <T> List<T> findList(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.LIST, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (List)((Object)result);
        }
        try {
            request.initTransIfRequired();
            List<T> list = request.findList();
            request.endTransIfRequired();
            return list;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public SqlRow findUnique(SqlQuery query, Transaction t) {
        List<SqlRow> list = this.findList(query, t);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            String m = "Unique expecting 0 or 1 rows but got [" + list.size() + "]";
            throw new PersistenceException(m);
        }
        return list.get(0);
    }

    @Override
    public SqlFutureList findFutureList(SqlQuery query, Transaction t) {
        SpiSqlQuery spiQuery = (SpiSqlQuery)query;
        spiQuery.setFutureFetch(true);
        Transaction newTxn = this.createTransaction();
        CallableSqlQueryList call = new CallableSqlQueryList(this, query, newTxn);
        FutureTask<List<SqlRow>> futureTask = new FutureTask<List<SqlRow>>(call);
        this.backgroundExecutor.execute(futureTask);
        return new SqlQueryFutureList(query, futureTask);
    }

    @Override
    public List<SqlRow> findList(SqlQuery query, Transaction t) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, t);
        try {
            request.initTransIfRequired();
            List<SqlRow> list = request.findList();
            request.endTransIfRequired();
            return list;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public Set<SqlRow> findSet(SqlQuery query, Transaction t) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, t);
        try {
            request.initTransIfRequired();
            Set<SqlRow> set = request.findSet();
            request.endTransIfRequired();
            return set;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public Map<?, SqlRow> findMap(SqlQuery query, Transaction t) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, t);
        try {
            request.initTransIfRequired();
            Map<?, SqlRow> map = request.findMap();
            request.endTransIfRequired();
            return map;
        }
        catch (RuntimeException ex) {
            request.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public void save(Object bean) {
        this.save(bean, null);
    }

    @Override
    public void save(Object bean, Transaction t) {
        if (bean == null) {
            throw new NullPointerException(Message.msg("bean.isnull"));
        }
        this.persister.save(bean, t);
    }

    @Override
    public void update(Object bean) {
        this.update(bean, null, null);
    }

    @Override
    public void update(Object bean, Set<String> updateProps) {
        this.update(bean, updateProps, null);
    }

    @Override
    public void update(Object bean, Transaction t) {
        this.update(bean, null, t);
    }

    @Override
    public void update(Object bean, Set<String> updateProps, Transaction t) {
        this.update(bean, updateProps, t, this.defaultDeleteMissingChildren, this.defaultUpdateNullProperties);
    }

    @Override
    public void update(Object bean, Set<String> updateProps, Transaction t, boolean deleteMissingChildren, boolean updateNullProperties) {
        if (bean == null) {
            throw new NullPointerException(Message.msg("bean.isnull"));
        }
        this.persister.forceUpdate(bean, updateProps, t, deleteMissingChildren, updateNullProperties);
    }

    @Override
    public void insert(Object bean) {
        this.insert(bean, null);
    }

    @Override
    public void insert(Object bean, Transaction t) {
        if (bean == null) {
            throw new NullPointerException(Message.msg("bean.isnull"));
        }
        this.persister.forceInsert(bean, t);
    }

    @Override
    public int deleteManyToManyAssociations(Object ownerBean, String propertyName) {
        return this.deleteManyToManyAssociations(ownerBean, propertyName, null);
    }

    @Override
    public int deleteManyToManyAssociations(Object ownerBean, String propertyName, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            int rc = this.persister.deleteManyToManyAssociations(ownerBean, propertyName, trans);
            wrap.commitIfCreated();
            return rc;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void saveManyToManyAssociations(Object ownerBean, String propertyName) {
        this.saveManyToManyAssociations(ownerBean, propertyName, null);
    }

    @Override
    public void saveManyToManyAssociations(Object ownerBean, String propertyName, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            this.persister.saveManyToManyAssociations(ownerBean, propertyName, trans);
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void saveAssociation(Object ownerBean, String propertyName) {
        this.saveAssociation(ownerBean, propertyName, null);
    }

    @Override
    public void saveAssociation(Object ownerBean, String propertyName, Transaction t) {
        Set<String> loadedProps;
        if (ownerBean instanceof EntityBean && (loadedProps = ((EntityBean)ownerBean)._ebean_getIntercept().getLoadedProps()) != null && !loadedProps.contains(propertyName)) {
            logger.fine("Skip saveAssociation as property " + propertyName + " is not loaded");
            return;
        }
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            this.persister.saveAssociation(ownerBean, propertyName, trans);
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int save(Iterator<?> it) {
        return this.save(it, null);
    }

    @Override
    public int save(Collection<?> c) {
        return this.save(c.iterator(), null);
    }

    @Override
    public int save(Iterator<?> it, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            int saveCount = 0;
            while (it.hasNext()) {
                Object bean = it.next();
                this.persister.save(bean, trans);
                ++saveCount;
            }
            wrap.commitIfCreated();
            return saveCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int delete(Class<?> beanType, Object id) {
        return this.delete(beanType, id, null);
    }

    @Override
    public int delete(Class<?> beanType, Object id, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            int rowCount = this.persister.delete(beanType, id, trans);
            wrap.commitIfCreated();
            return rowCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void delete(Class<?> beanType, Collection<?> ids) {
        this.delete(beanType, ids, null);
    }

    @Override
    public void delete(Class<?> beanType, Collection<?> ids, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            this.persister.deleteMany(beanType, ids, trans);
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void delete(Object bean) {
        this.delete(bean, null);
    }

    @Override
    public void delete(Object bean, Transaction t) {
        if (bean == null) {
            throw new NullPointerException(Message.msg("bean.isnull"));
        }
        this.persister.delete(bean, t);
    }

    @Override
    public int delete(Iterator<?> it) {
        return this.delete(it, null);
    }

    @Override
    public int delete(Collection<?> c) {
        return this.delete(c.iterator(), null);
    }

    @Override
    public int delete(Iterator<?> it, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            int deleteCount = 0;
            while (it.hasNext()) {
                Object bean = it.next();
                this.persister.delete(bean, trans);
                ++deleteCount;
            }
            wrap.commitIfCreated();
            return deleteCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int execute(CallableSql callSql, Transaction t) {
        return this.persister.executeCallable(callSql, t);
    }

    @Override
    public int execute(CallableSql callSql) {
        return this.execute(callSql, null);
    }

    @Override
    public int execute(SqlUpdate updSql, Transaction t) {
        return this.persister.executeSqlUpdate(updSql, t);
    }

    @Override
    public int execute(SqlUpdate updSql) {
        return this.execute(updSql, null);
    }

    @Override
    public int execute(Update<?> update, Transaction t) {
        return this.persister.executeOrmUpdate(update, t);
    }

    @Override
    public int execute(Update<?> update) {
        return this.execute(update, null);
    }

    public <T> BeanManager<T> getBeanManager(Class<T> beanClass) {
        return this.beanDescriptorManager.getBeanManager(beanClass);
    }

    @Override
    public List<BeanDescriptor<?>> getBeanDescriptors() {
        return this.beanDescriptorManager.getBeanDescriptorList();
    }

    public void register(BeanPersistController c) {
        List<BeanDescriptor<?>> list = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).register(c);
        }
    }

    public void deregister(BeanPersistController c) {
        List<BeanDescriptor<?>> list = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).deregister(c);
        }
    }

    @Override
    public boolean isSupportedType(Type genericType) {
        ParamTypeHelper.TypeInfo typeInfo = ParamTypeHelper.getTypeInfo(genericType);
        if (typeInfo == null) {
            return false;
        }
        Class<?> beanType = typeInfo.getBeanType();
        if (JsonElement.class.isAssignableFrom(beanType)) {
            return true;
        }
        return this.getBeanDescriptor(typeInfo.getBeanType()) != null;
    }

    @Override
    public Object getBeanId(Object bean) {
        BeanDescriptor<?> desc = this.getBeanDescriptor(bean.getClass());
        if (desc == null) {
            String m = bean.getClass().getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        return desc.getId(bean);
    }

    @Override
    public <T> BeanDescriptor<T> getBeanDescriptor(Class<T> beanClass) {
        return this.beanDescriptorManager.getBeanDescriptor(beanClass);
    }

    @Override
    public List<BeanDescriptor<?>> getBeanDescriptors(String tableName) {
        return this.beanDescriptorManager.getBeanDescriptors(tableName);
    }

    @Override
    public BeanDescriptor<?> getBeanDescriptorById(String descriptorId) {
        return this.beanDescriptorManager.getBeanDescriptorById(descriptorId);
    }

    @Override
    public void remoteTransactionEvent(RemoteTransactionEvent event) {
        this.transactionManager.remoteTransactionEvent(event);
    }

    TransWrapper initTransIfRequired(Transaction t) {
        if (t != null) {
            return new TransWrapper((SpiTransaction)t, false);
        }
        boolean wasCreated = false;
        SpiTransaction trans = this.transactionScopeManager.get();
        if (trans == null) {
            trans = this.transactionManager.createTransaction(false, -1);
            wasCreated = true;
        }
        return new TransWrapper(trans, wasCreated);
    }

    @Override
    public SpiTransaction createServerTransaction(boolean isExplicit, int isolationLevel) {
        return this.transactionManager.createTransaction(isExplicit, isolationLevel);
    }

    @Override
    public SpiTransaction createQueryTransaction() {
        return this.transactionManager.createQueryTransaction();
    }

    @Override
    public CallStack createCallStack() {
        int startIndex;
        Object[] stackTrace = Thread.currentThread().getStackTrace();
        for (startIndex = 5; startIndex < stackTrace.length && stackTrace[startIndex].getClassName().startsWith(AVAJE_EBEAN); ++startIndex) {
        }
        int stackLength = stackTrace.length - startIndex;
        if (stackLength > this.maxCallStack) {
            stackLength = this.maxCallStack;
        }
        StackTraceElement[] finalTrace = new StackTraceElement[stackLength];
        for (int i = 0; i < stackLength; ++i) {
            finalTrace[i] = stackTrace[i + startIndex];
        }
        if (stackLength < 1) {
            throw new RuntimeException("StackTraceElement size 0?  stack: " + Arrays.toString(stackTrace));
        }
        return new CallStack(finalTrace);
    }

    @Override
    public JsonContext createJsonContext() {
        return this.jsonContext;
    }

    private final class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            try {
                if (DefaultServer.this.mbeanServer != null) {
                    DefaultServer.this.mbeanServer.unregisterMBean(new ObjectName(DefaultServer.this.mbeanName + ",function=Logging"));
                    DefaultServer.this.mbeanServer.unregisterMBean(new ObjectName(DefaultServer.this.mbeanName + ",key=AutoFetch"));
                }
            }
            catch (Exception e) {
                String msg = "Error unregistering Ebean " + DefaultServer.this.mbeanName;
                logger.log(Level.SEVERE, msg, e);
            }
            DefaultServer.this.transactionManager.shutdown();
            DefaultServer.this.autoFetchManager.shutdown();
            DefaultServer.this.backgroundExecutor.shutdown();
        }
    }
}

