/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyMap {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, String> map = new LinkedHashMap();

    PropertyMap() {
    }

    public String toString() {
        return this.map.toString();
    }

    public synchronized boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public synchronized int getInt(String key, int defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public synchronized String get(String key, String defaultValue) {
        String value = this.map.get(key.toLowerCase());
        return value == null ? defaultValue : value;
    }

    public synchronized String get(String key) {
        return this.map.get(key.toLowerCase());
    }

    synchronized void putAll(Map<String, String> keyValueMap) {
        for (Map.Entry<String, String> entry : keyValueMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    synchronized String put(String key, String value) {
        return this.map.put(key.toLowerCase(), value);
    }

    synchronized String remove(String key) {
        return (String)this.map.remove(key.toLowerCase());
    }
}

