/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.InvalidValue;
import com.avaje.ebean.ValidationException;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebean.event.BeanPersistRequest;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.server.core.ConcurrencyMode;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanManager;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.jmx.MAdminLogging;
import com.avaje.ebeaninternal.server.persist.BatchControl;
import com.avaje.ebeaninternal.server.persist.PersistExecute;
import com.avaje.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import com.avaje.ebeaninternal.server.transaction.RemoteBeanPersist;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Set;
import javax.persistence.OptimisticLockException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistRequestBean<T>
extends PersistRequest
implements BeanPersistRequest<T> {
    protected final BeanManager<T> beanManager;
    protected final BeanDescriptor<T> beanDescriptor;
    protected final BeanPersistListener<T> beanPersistListener;
    protected final BeanPersistController controller;
    protected final EntityBeanIntercept intercept;
    protected final Object parentBean;
    protected final boolean isDirty;
    protected final boolean vanilla;
    protected final T bean;
    protected T oldValues;
    protected ConcurrencyMode concurrencyMode;
    protected final Set<String> loadedProps;
    protected Object idValue;
    protected final Set<String> changedProps;
    protected boolean notifyCache;

    public PersistRequestBean(SpiEbeanServer server, T bean, Object parentBean, BeanManager<T> mgr, SpiTransaction t, PersistExecute persistExecute, Set<String> updateProps, ConcurrencyMode concurrencyMode) {
        super(server, t, persistExecute);
        this.beanManager = mgr;
        this.beanDescriptor = mgr.getBeanDescriptor();
        this.beanPersistListener = this.beanDescriptor.getPersistListener();
        this.bean = bean;
        this.parentBean = parentBean;
        this.controller = this.beanDescriptor.getPersistController();
        this.concurrencyMode = this.beanDescriptor.getConcurrencyMode();
        this.concurrencyMode = concurrencyMode;
        this.loadedProps = updateProps;
        this.changedProps = updateProps;
        this.vanilla = true;
        this.isDirty = true;
        this.oldValues = bean;
        this.intercept = null;
    }

    public PersistRequestBean(SpiEbeanServer server, T bean, Object parentBean, BeanManager<T> mgr, SpiTransaction t, PersistExecute persistExecute) {
        super(server, t, persistExecute);
        this.beanManager = mgr;
        this.beanDescriptor = mgr.getBeanDescriptor();
        this.beanPersistListener = this.beanDescriptor.getPersistListener();
        this.bean = bean;
        this.parentBean = parentBean;
        this.controller = this.beanDescriptor.getPersistController();
        this.concurrencyMode = this.beanDescriptor.getConcurrencyMode();
        if (bean instanceof EntityBean) {
            this.intercept = ((EntityBean)bean)._ebean_getIntercept();
            if (this.intercept.isReference()) {
                this.concurrencyMode = ConcurrencyMode.NONE;
            }
            this.isDirty = this.intercept.isDirty();
            this.changedProps = this.intercept.getChangedProps();
            this.loadedProps = this.intercept.getLoadedProps();
            this.oldValues = this.intercept.getOldValues();
            this.vanilla = false;
        } else {
            this.vanilla = true;
            this.isDirty = true;
            this.loadedProps = null;
            this.changedProps = null;
            this.intercept = null;
            if (this.concurrencyMode.equals((Object)ConcurrencyMode.ALL)) {
                this.concurrencyMode = ConcurrencyMode.NONE;
            }
        }
    }

    public boolean isNotify() {
        return this.notifyCache || this.isNotifyPersistListener();
    }

    public boolean isNotifyCache() {
        return this.notifyCache;
    }

    public boolean isNotifyPersistListener() {
        return this.beanPersistListener != null;
    }

    public void notifyCache() {
        if (this.notifyCache) {
            this.beanDescriptor.cacheRemove(this.idValue);
        }
    }

    public RemoteBeanPersist notifyLocalPersistListener() {
        if (this.isLocalNotifyPersistListener()) {
            return this.createRemoteBeanPersist();
        }
        return null;
    }

    private boolean isLocalNotifyPersistListener() {
        if (this.beanPersistListener == null) {
            return false;
        }
        switch (this.type) {
            case INSERT: {
                return this.beanPersistListener.inserted(this.bean);
            }
            case UPDATE: {
                return this.beanPersistListener.updated(this.bean, this.getUpdatedProperties());
            }
            case DELETE: {
                return this.beanPersistListener.deleted(this.bean);
            }
        }
        return false;
    }

    public boolean isParent(Object o) {
        return o == this.parentBean;
    }

    private int getBeanHash(Object b) {
        Object id = this.beanDescriptor.getId(b);
        int hc = b.getClass().getName().hashCode();
        return hc * 31 + id.hashCode();
    }

    public void registerBean() {
        this.transaction.registerBean(this.getBeanHash(this.bean));
    }

    public void unregisterBean() {
        this.transaction.unregisterBean(this.getBeanHash(this.bean));
    }

    public boolean isRegistered() {
        if (this.transaction == null) {
            return false;
        }
        return this.transaction.isRegisteredBean(this.getBeanHash(this.bean));
    }

    @Override
    public void setType(PersistRequest.Type type) {
        this.type = type;
        if (type == PersistRequest.Type.DELETE || type == PersistRequest.Type.UPDATE) {
            if (this.oldValues == null) {
                this.oldValues = this.bean;
            }
            if (this.beanDescriptor.isCaching()) {
                this.notifyCache = true;
            }
        }
    }

    public BeanManager<T> getBeanManager() {
        return this.beanManager;
    }

    public BeanDescriptor<T> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public ConcurrencyMode getConcurrencyMode() {
        return this.concurrencyMode;
    }

    @Override
    public Set<String> getLoadedProperties() {
        return this.loadedProps;
    }

    public String getFullName() {
        return this.beanDescriptor.getFullName();
    }

    @Override
    public T getBean() {
        return this.bean;
    }

    @Override
    public T getOldValues() {
        return this.oldValues;
    }

    public Object getParentBean() {
        return this.parentBean;
    }

    public BeanPersistController getBeanController() {
        return this.controller;
    }

    public EntityBeanIntercept getEntityBeanIntercept() {
        return this.intercept;
    }

    public void validate() {
        InvalidValue errs = this.beanDescriptor.validate(false, this.bean);
        if (errs != null) {
            throw new ValidationException(errs);
        }
    }

    public boolean isLoadedProperty(BeanProperty prop) {
        if (this.loadedProps == null) {
            return true;
        }
        return this.loadedProps.contains(prop.getName());
    }

    @Override
    public int executeNow() {
        switch (this.type) {
            case INSERT: {
                this.persistExecute.executeInsertBean(this);
                return -1;
            }
            case UPDATE: {
                this.persistExecute.executeUpdateBean(this);
                return -1;
            }
            case DELETE: {
                this.persistExecute.executeDeleteBean(this);
                return -1;
            }
        }
        throw new RuntimeException("Invalid type " + (Object)((Object)this.type));
    }

    @Override
    public int executeOrQueue() {
        boolean batch = this.transaction.isBatchThisRequest();
        BatchControl control = this.transaction.getBatchControl();
        if (control != null) {
            return control.executeOrQueue(this, batch);
        }
        if (batch) {
            control = this.persistExecute.createBatchControl(this.transaction);
            return control.executeOrQueue(this, batch);
        }
        return this.executeNow();
    }

    @Override
    public void setGeneratedKey(Object idValue) {
        if (idValue != null) {
            this.idValue = idValue = this.beanDescriptor.convertSetId(idValue, this.bean);
        }
    }

    public void setBoundId(Object idValue) {
        this.idValue = idValue;
    }

    @Override
    public void checkRowCount(int rowCount) throws SQLException {
        if (rowCount != 1) {
            String m = Message.msg("persist.conc2", "" + rowCount);
            throw new OptimisticLockException(m, null, this.bean);
        }
    }

    @Override
    public void postExecute() throws SQLException {
        if (this.controller != null) {
            this.controllerPost();
        }
        if (this.intercept != null) {
            this.intercept.setLoaded();
        }
        this.addEvent();
        if (this.transaction.isLoggingOn() && this.logLevel >= MAdminLogging.SUMMARY) {
            this.logSummary();
        }
    }

    private void controllerPost() {
        switch (this.type) {
            case INSERT: {
                this.controller.postInsert(this);
                break;
            }
            case UPDATE: {
                this.controller.postUpdate(this);
                break;
            }
            case DELETE: {
                this.controller.postDelete(this);
                break;
            }
        }
    }

    private void logSummary() {
        String name = this.beanDescriptor.getName();
        switch (this.type) {
            case INSERT: {
                this.transaction.log("Inserted [" + name + "] [" + this.idValue + "]");
                break;
            }
            case UPDATE: {
                this.transaction.log("Updated [" + name + "] [" + this.idValue + "]");
                break;
            }
            case DELETE: {
                this.transaction.log("Deleted [" + name + "] [" + this.idValue + "]");
                break;
            }
        }
    }

    private void addEvent() {
        TransactionEvent event = this.transaction.getEvent();
        if (event != null) {
            event.add(this);
        }
    }

    public ConcurrencyMode determineConcurrencyMode() {
        BeanProperty prop;
        if (this.loadedProps != null && this.concurrencyMode.equals((Object)ConcurrencyMode.VERSION) && ((prop = this.beanDescriptor.firstVersionProperty()) == null || !this.loadedProps.contains(prop.getName()))) {
            this.concurrencyMode = ConcurrencyMode.ALL;
        }
        return this.concurrencyMode;
    }

    public boolean isDynamicUpdateSql() {
        return !this.vanilla && this.beanDescriptor.isUpdateChangesOnly() || this.loadedProps != null;
    }

    public GenerateDmlRequest createGenerateDmlRequest(boolean emptyStringAsNull) {
        if (this.beanDescriptor.isUpdateChangesOnly()) {
            return new GenerateDmlRequest(emptyStringAsNull, this.changedProps, this.oldValues);
        }
        return new GenerateDmlRequest(emptyStringAsNull, this.loadedProps, this.oldValues);
    }

    @Override
    public Set<String> getUpdatedProperties() {
        if (this.changedProps != null) {
            return this.changedProps;
        }
        return this.loadedProps;
    }

    public boolean hasChanged(BeanProperty prop) {
        return this.changedProps.contains(prop.getName());
    }

    private RemoteBeanPersist createRemoteBeanPersist() {
        return new RemoteBeanPersist(this.beanDescriptor.getFullName(), this.type, (Serializable)this.idValue);
    }
}

