/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.ddl;

import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbDdlSyntax;
import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.config.dbplatform.DbTypeMap;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.type.ScalarType;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DdlGenContext {
    private final StringWriter stringWriter = new StringWriter();
    private final DbTypeMap dbTypeMap;
    private final DbDdlSyntax ddlSyntax;
    private final String newLine;
    private String lastContent;
    private Set<String> intersectionTables = new HashSet<String>();
    private List<String> intersectionTablesCreateDdl = new ArrayList<String>();
    private List<String> intersectionTablesFkDdl = new ArrayList<String>();
    private final DatabasePlatform dbPlatform;
    private final NamingConvention namingConvention;
    private int fkCount;
    private int ixCount;

    public DdlGenContext(DatabasePlatform dbPlatform, NamingConvention namingConvention) {
        this.dbPlatform = dbPlatform;
        this.dbTypeMap = dbPlatform.getDbTypeMap();
        this.ddlSyntax = dbPlatform.getDbDdlSyntax();
        this.newLine = this.ddlSyntax.getNewLine();
        this.namingConvention = namingConvention;
    }

    public DatabasePlatform getDbPlatform() {
        return this.dbPlatform;
    }

    public boolean isProcessIntersectionTable(String tableName) {
        return this.intersectionTables.add(tableName);
    }

    public void addCreateIntersectionTable(String createTableDdl) {
        this.intersectionTablesCreateDdl.add(createTableDdl);
    }

    public void addIntersectionTableFk(String intTableFk) {
        this.intersectionTablesFkDdl.add(intTableFk);
    }

    public void addIntersectionCreateTables() {
        for (String intTableCreate : this.intersectionTablesCreateDdl) {
            this.stringWriter.write(this.newLine);
            this.stringWriter.write(intTableCreate);
        }
    }

    public void addIntersectionFkeys() {
        this.stringWriter.write(this.newLine);
        this.stringWriter.write(this.newLine);
        for (String intTableFk : this.intersectionTablesFkDdl) {
            this.stringWriter.write(this.newLine);
            this.stringWriter.write(intTableFk);
        }
    }

    public String getContent() {
        return this.stringWriter.toString();
    }

    public DbTypeMap getDbTypeMap() {
        return this.dbTypeMap;
    }

    public DbDdlSyntax getDdlSyntax() {
        return this.ddlSyntax;
    }

    public String getColumnDefn(BeanProperty p) {
        DbType dbType = this.getDbType(p);
        return p.renderDbType(dbType);
    }

    private DbType getDbType(BeanProperty p) {
        ScalarType<?> scalarType = p.getScalarType();
        if (scalarType == null) {
            throw new RuntimeException("No scalarType for " + p.getFullBeanName());
        }
        if (p.isDbEncrypted()) {
            return this.dbTypeMap.get(p.getDbEncryptedType());
        }
        return this.dbTypeMap.get(scalarType.getJdbcType());
    }

    public DdlGenContext write(String content, int minWidth) {
        content = this.pad(content, minWidth);
        if (this.lastContent != null) {
            this.stringWriter.write(this.lastContent);
        }
        this.lastContent = content;
        return this;
    }

    public DdlGenContext write(String content) {
        return this.write(content, 0);
    }

    public DdlGenContext writeNewLine() {
        this.flush().write(this.newLine);
        return this;
    }

    public DdlGenContext removeLast() {
        if (this.lastContent == null) {
            throw new RuntimeException("No lastContent to remove?");
        }
        this.lastContent = null;
        return this;
    }

    public DdlGenContext flush() {
        if (this.lastContent != null) {
            this.stringWriter.write(this.lastContent);
        }
        this.lastContent = null;
        return this;
    }

    private String padding(int length) {
        StringBuffer sb = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String pad(String content, int minWidth) {
        if (minWidth > 0 && content.length() < minWidth) {
            int padding = minWidth - content.length();
            return content + this.padding(padding);
        }
        return content;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public int incrementFkCount() {
        return ++this.fkCount;
    }

    public int incrementIxCount() {
        return ++this.ixCount;
    }
}

